/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Frame;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.Util;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TaskVisuDependencyPage
extends WizardPage {
    private Composite container;
    private mxGraph graph;
    private mxGraphComponent graph_view;
    private Button cbConsiderPrecedence;
    private ConstraintsModel cm;
    private OMMapping model;
    private Set<Object> consideredGraphEdges = new HashSet<Object>();
    private List<OMAllocation> allocationList;
    private List<OMTask> tasklist;
    private Collection<OMEdge> consideredEdges;

    protected TaskVisuDependencyPage(String pageName) {
        super(pageName);
    }

    public TaskVisuDependencyPage(OMMapping model, ConstraintsModel cm) {
        super("Task Visualisation: Task Dependencies");
        this.setTitle("Task Visualisation: Task Dependencies");
        this.model = model;
        this.cm = cm;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        try {
            this.allocationList = this.model.getAllocationList();
            this.tasklist = this.allocationList.stream().map(OMAllocation::getTask).collect(Collectors.toList());
            OMUtil.createOMTaskGraph(this.tasklist, (ConstraintsModel)this.cm);
            this.createGraph();
            Composite embeddedComposite = new Composite(this.container, 0x1040000);
            GridData embedGraphData = new GridData(4, 4, true, true);
            embedGraphData.verticalSpan = 2;
            embeddedComposite.setLayoutData((Object)embedGraphData);
            Frame frame = SWT_AWT.new_Frame((Composite)embeddedComposite);
            frame.add((Component)this.graph_view);
            frame.setVisible(true);
            this.cbConsiderPrecedence = new Button(this.container, 32);
            this.cbConsiderPrecedence.setText("Consider task precedence!\n");
            Label filterinfo = new Label(this.container, 18496);
            filterinfo.setText("Relations filter: \n- No edges with unequal periods of pre- and post-task.\n- No edges with same pre- and post-task (selftransition).\n- If there are multiple edges between two tasks the edge \n  with the highest release time is chosen.");
            this.cbConsiderPrecedence.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!OMUtil.isDAG((Collection)TaskVisuDependencyPage.this.consideredEdges)) {
                        MessageDialog.openInformation((Shell)TaskVisuDependencyPage.this.getShell(), (String)"Task Visualization", (String)"Directed cylic Graphs are not supported!");
                        TaskVisuDependencyPage.this.cbConsiderPrecedence.setSelection(false);
                        return;
                    }
                    if (TaskVisuDependencyPage.this.cbConsiderPrecedence.getSelection()) {
                        TaskVisuDependencyPage.this.graph.setCellStyles(mxConstants.STYLE_STROKECOLOR, "red", TaskVisuDependencyPage.this.consideredGraphEdges.toArray());
                    } else {
                        TaskVisuDependencyPage.this.graph.setCellStyles(mxConstants.STYLE_STROKECOLOR, "blue", TaskVisuDependencyPage.this.consideredGraphEdges.toArray());
                    }
                }
            });
        }
        catch (MalformedModelException e) {
            e.printStackTrace();
        }
        this.setControl((Control)this.container);
        this.setPageComplete(true);
    }

    private void createGraph() {
        this.graph = new mxGraph();
        this.graph.setCellsEditable(false);
        this.addModelDataToGraph();
        this.layoutGraph();
        this.graph_view = new mxGraphComponent(this.graph);
        this.graph_view.setConnectable(false);
    }

    private void addModelDataToGraph() {
        Object parent = this.graph.getDefaultParent();
        HashMap<OMTask, Object> celllist = new HashMap<OMTask, Object>();
        for (OMAllocation alloc : this.allocationList) {
            OMTask task = alloc.getTask();
            Object x = this.graph.insertVertex(parent, null, (Object)task.getTaskRef().getName(), 0.0, 0.0, 80.0, 30.0);
            celllist.put(task, x);
        }
        HashMap<OMEdge, Object> edgemap = new HashMap<OMEdge, Object>();
        for (OMAllocation alloc : this.allocationList) {
            OMTask pre = alloc.getTask();
            OMCore core = alloc.getCore();
            for (OMEdge postEdge : pre.getPosts()) {
                OMTask post = postEdge.getPost();
                long instruction = postEdge.getReleaseInstruction();
                try {
                    long time = OMUtil.getProcessingTime((OMCore)core, (long)instruction);
                    Object edge = this.graph.insertEdge(parent, null, (Object)(time + " ps"), celllist.get(pre), celllist.get(post));
                    edgemap.put(postEdge, edge);
                }
                catch (MalformedModelException e) {
                    e.printStackTrace();
                }
            }
        }
        this.consideredEdges = Util.getConsideredEdges(this.tasklist);
        for (OMEdge edge : this.consideredEdges) {
            this.consideredGraphEdges.add(edgemap.get(edge));
        }
    }

    public boolean considerTaskPrecedence() {
        if (this.cbConsiderPrecedence != null) {
            return this.cbConsiderPrecedence.getSelection();
        }
        return false;
    }

    public Collection<OMEdge> getTaskPrecedences() {
        return this.consideredEdges;
    }

    private void layoutGraph() {
        new mxHierarchicalLayout(this.graph).execute(this.graph.getDefaultParent());
    }
}

