/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMEdge;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.ISystemProxy;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SimException;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SystemProxyFactory;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.SchedulerAlgorithmRegister;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuDependencyPage;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuOverviewPage;
import org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards.TaskVisuSchedulingPage;
import org.eclipse.app4mc.multicore.execution.ui.traceview.TraceViewUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class TaskVisuWizard
extends Wizard {
    protected TaskVisuOverviewPage page1;
    protected TaskVisuDependencyPage page2;
    protected TaskVisuSchedulingPage page3;
    protected IEMTraceWidget tw;
    protected OMMapping omModel;
    protected ConstraintsModel cm;
    private ISystemProxy systemProxy;

    public TaskVisuWizard(IEMTraceWidget tw, OMMapping model, ConstraintsModel cm) {
        this.tw = tw;
        this.omModel = model;
        this.cm = cm;
    }

    public String getWindowTitle() {
        return "Task Visualization Wizard";
    }

    public void addPages() {
        this.page1 = new TaskVisuOverviewPage(this.omModel);
        this.page2 = new TaskVisuDependencyPage(this.omModel, this.cm);
        this.page3 = new TaskVisuSchedulingPage(this.tw, this.omModel);
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
    }

    public boolean performFinish() {
        final String sched = this.page3.getScheduling();
        final long schedtime = this.page3.getSimuntil();
        final EMTimeType timeScale = this.page3.getTimeScale();
        final Collection<OMEdge> taskPrecedence = this.page2.getTaskPrecedences();
        final boolean considerPrecedence = this.page2.considerTaskPrecedence();
        Job job = new Job("Task Visualisation Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ExecutionModel execResult = new ExecutionModel();
                    execResult.setTimeScale(timeScale);
                    TaskVisuWizard.this.systemProxy = SystemProxyFactory.createEMSystemProxyFromOMMapping((long)timeScale.picos(), (Supplier)SchedulerAlgorithmRegister.schedulerFactoryByName((String)sched), (OMMapping)TaskVisuWizard.this.omModel, (ExecutionModel)execResult);
                    if (considerPrecedence) {
                        for (OMEdge edge : taskPrecedence) {
                            OMCore preCore = OMUtil.getCoreForTask((OMMapping)TaskVisuWizard.this.omModel, (OMTask)edge.getPre());
                            OMCore postCore = OMUtil.getCoreForTask((OMMapping)TaskVisuWizard.this.omModel, (OMTask)edge.getPost());
                            long releaseTime = OMUtil.getProcessingTime((OMCore)preCore, (long)edge.getReleaseInstruction());
                            TaskVisuWizard.this.systemProxy.addTaskPrecedence(preCore.getCoreRef().getName(), edge.getPre().getTaskRef().getName(), releaseTime, postCore.getCoreRef().getName(), edge.getPost().getTaskRef().getName());
                        }
                    }
                    TaskVisuWizard.this.tw.addExecutionModel(execResult);
                    System.err.println("STARTING SIM");
                    long cur = System.currentTimeMillis();
                    TaskVisuWizard.this.systemProxy.compute(schedtime);
                    monitor.done();
                    System.err.println("READY duration:" + (System.currentTimeMillis() - cur));
                }
                catch (MalformedModelException | SimException e) {
                    e.printStackTrace();
                    TaskVisuWizard.getDisplay().asyncExec(new Runnable((Exception)e){
                        private final /* synthetic */ Exception val$e;
                        {
                            this.val$e = exception;
                        }

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)TraceViewUtil.getTraceViewPart().getSite().getShell(), (String)"Task Visualization", (String)this.val$e.getMessage());
                        }
                    });
                }
                return Status.OK_STATUS;
            }

            protected void canceling() {
                super.canceling();
                System.err.println("Canceling task visualization");
                if (TaskVisuWizard.this.systemProxy != null) {
                    TaskVisuWizard.this.systemProxy.interruptComputation();
                }
            }
        };
        job.schedule();
        return true;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

