/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.taskgen.pragmatic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Distribution;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.SporadicActivation;
import org.eclipse.app4mc.amalthea.model.SporadicStimulus;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.multicore.openmapping.OpenMappingPlugin;
import org.eclipse.app4mc.multicore.openmapping.algorithms.AbstractTaskCreationAlgorithm;
import org.eclipse.app4mc.multicore.openmapping.model.OMProcessPrototype;
import org.eclipse.app4mc.multicore.openmapping.model.OMRunnable;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class PragmaticTaskGenerator
extends AbstractTaskCreationAlgorithm {
    private final Map<Activation, Stimulus> mActivationStimuli = new HashMap<Activation, Stimulus>();
    private final ArrayList<OMProcessPrototype> lProcessPrototypes = new ArrayList();
    private final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");

    private boolean initProcessPrototypes() {
        if (this.getAmaltheaModel().getSwModel().getProcessPrototypes().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid SWModel.\nThere are no ProcessPrototypes in this model.\nLeaving Algorithm...", null);
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getAmaltheaModel().getSwModel().getProcessPrototypes().size() + " Process Prototype(s)");
        for (ProcessPrototype pp : this.getAmaltheaModel().getSwModel().getProcessPrototypes()) {
            OMProcessPrototype ompp = new OMProcessPrototype(pp);
            this.lProcessPrototypes.add(ompp);
        }
        return true;
    }

    private boolean convertActivations() {
        if (this.getAmaltheaModel().getSwModel().getActivations().size() <= 0) {
            UniversalHandler.getInstance().logWarn("Unexpected SWModel: There are no Activation elements in this model. Leaving Algorithm...");
            return false;
        }
        UniversalHandler.getInstance().logCon("Found " + this.getAmaltheaModel().getSwModel().getActivations().size() + " Activation element(s)");
        for (Activation activation : this.getAmaltheaModel().getSwModel().getActivations()) {
            if (activation instanceof PeriodicActivation) {
                PeriodicStimulus stimuliPeriodic = this.convertPeriodicActivation((PeriodicActivation)activation);
                this.getAmaltheaModel().getStimuliModel().getStimuli().add((Object)stimuliPeriodic);
                this.mActivationStimuli.put(activation, (Stimulus)stimuliPeriodic);
                continue;
            }
            if (activation instanceof SporadicActivation) {
                SporadicStimulus stimuliSporadic = this.convertSporadicActivation((SporadicActivation)activation);
                this.getAmaltheaModel().getStimuliModel().getStimuli().add((Object)stimuliSporadic);
                this.mActivationStimuli.put(activation, (Stimulus)stimuliSporadic);
                continue;
            }
            UniversalHandler.getInstance().log("Unhandled Activation element.\nSkipping...", null);
        }
        return true;
    }

    private PeriodicStimulus convertPeriodicActivation(PeriodicActivation activation) {
        String name = activation.getName();
        UniversalHandler.getInstance().logCon("Connverting Periodic Activation Element '" + name);
        PeriodicStimulus stimuliPeriodic = this.getStimuliInstance().createPeriodicStimulus();
        stimuliPeriodic.setName(name);
        if (activation.getOffset() != null) {
            stimuliPeriodic.setOffset((Time)EcoreUtil.copy((EObject)activation.getOffset()));
        }
        if (activation.getMax() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getMax()));
        }
        if (activation.getMin() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getMin()));
        }
        if (activation.getRecurrence() != null) {
            stimuliPeriodic.setRecurrence((Time)EcoreUtil.copy((EObject)activation.getRecurrence()));
        }
        return stimuliPeriodic;
    }

    private SporadicStimulus convertSporadicActivation(SporadicActivation activation) {
        String name = activation.getName();
        UniversalHandler.getInstance().logCon("Connverting Sporiadic Activation Element '" + name);
        SporadicStimulus stimuliSporadic = this.getStimuliInstance().createSporadicStimulus();
        stimuliSporadic.setName(name);
        if (activation.getActivationDeviation() != null) {
            Deviation stimuliDeviation = this.getStimuliInstance().createDeviation();
            if (activation.getActivationDeviation().getLowerBound() != null) {
                stimuliDeviation.setLowerBound((Object)((Time)EcoreUtil.copy((EObject)((Time)activation.getActivationDeviation().getLowerBound()))));
            }
            if (activation.getActivationDeviation().getUpperBound() != null) {
                stimuliDeviation.setLowerBound((Object)((Time)EcoreUtil.copy((EObject)((Time)activation.getActivationDeviation().getUpperBound()))));
            }
            if (activation.getActivationDeviation().getDistribution() != null) {
                stimuliDeviation.setDistribution((Distribution)EcoreUtil.copy((EObject)activation.getActivationDeviation().getDistribution()));
            }
            stimuliSporadic.setStimulusDeviation(stimuliDeviation);
        }
        return stimuliSporadic;
    }

    @Override
    public void createTasks() {
        UniversalHandler.getInstance().setPluginId(OpenMappingPlugin.getPluginId());
        if (OpenMappingPlugin.getDefault() != null) {
            UniversalHandler.getInstance().setLog(OpenMappingPlugin.getDefault().getLog());
        }
        UniversalHandler.getInstance().log("Entering Pragmatic Task-Creation algorithm.");
        this.getAmaltheaModel().setStimuliModel(this.getStimuliInstance().createStimuliModel());
        if (!this.initProcessPrototypes()) {
            UniversalHandler.getInstance().log("Error during ProcessPrototype initialization.\nLeaving Algorithm...", null);
            return;
        }
        UniversalHandler.getInstance().logCon("ProcessPrototypes successfully initialized.");
        if (!this.convertActivations()) {
            UniversalHandler.getInstance().logWarn("Warning: No Activation Elements found. Skipping conversion.");
        } else {
            UniversalHandler.getInstance().logCon("Activation elements successfully converted.");
        }
        UniversalHandler.getInstance().log("Runnable Dependency Graph has been successfully created.", null);
        int iTotalRunnables = 0;
        for (OMProcessPrototype epp : this.lProcessPrototypes) {
            String name = epp.getName();
            epp.createRunnableGraph();
            Set<OMRunnable> lRunnables = epp.getRunnableList();
            if (lRunnables.isEmpty()) {
                UniversalHandler.getInstance().logCon("Unexpected Runnable list (List Empty?).\nSkipping entry...");
                break;
            }
            Task task = this.getSwInstance().createTask();
            task.setName("Task_" + name);
            CallGraph cGraph = this.getSwInstance().createCallGraph();
            CallSequence cSeq = this.getSwInstance().createCallSequence();
            for (OMRunnable run : lRunnables) {
                TaskRunnableCall trc = this.getSwInstance().createTaskRunnableCall();
                trc.setRunnable(run.getRunnableRef());
                cSeq.getCalls().add((Object)trc);
            }
            cGraph.getGraphEntries().add((Object)cSeq);
            task.setCallGraph(cGraph);
            if (epp.getProcessPrototype().getActivation() != null) {
                task.getStimuli().add((Object)this.mActivationStimuli.get(epp.getProcessPrototype().getActivation()));
            }
            this.getAmaltheaModel().getSwModel().getTasks().add((Object)task);
            iTotalRunnables += lRunnables.size();
            String msg = "Added Task: '" + task.getName() + "', Runnables: " + lRunnables.size();
            System.out.println("-----------------------------------------------------------------");
            System.out.println(epp.toString());
            System.out.println(lRunnables);
            UniversalHandler.getInstance().logCon(msg);
            this.con.appendln(msg);
        }
        UniversalHandler.getInstance().logCon("Leaving Pragmatic Task-Creation algorithm.");
        this.setAmaltheaOutputModel((Amalthea)EcoreUtil.copy((EObject)this.getAmaltheaModel()));
        this.con.appendln("Done! " + iTotalRunnables + " Runnables in tasks\n");
        this.con.focus();
    }
}

