/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecProcessPrototypeRunnableInstructions
extends ModelSpec {
    public static ModelSpecProcessPrototypeRunnableInstructions build() {
        ModelSpecProcessPrototypeRunnableInstructions spec = new ModelSpecProcessPrototypeRunnableInstructions();
        spec.name = spec.specType = "Process Prototype's Runnables have Instructions";
        return spec;
    }

    private List<Runnable> getAllRunnablesOfProcessPrototypes(Amalthea model) {
        ArrayList<Runnable> listRun = new ArrayList<Runnable>();
        for (ProcessPrototype procProto : model.getSwModel().getProcessPrototypes()) {
            for (TaskRunnableCall call : procProto.getRunnableCalls()) {
                listRun.add(call.getRunnable());
            }
        }
        return listRun;
    }

    private boolean checkInstruction(Runnable run) {
        for (RunnableItem item : run.getRunnableItems()) {
            if (!(item instanceof RunnableInstructions)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Runnable run : this.getAllRunnablesOfProcessPrototypes(model)) {
            if (this.checkInstruction(run)) continue;
            cond &= false;
            this.log("Runnable " + run.getName() + " doesn't have Instructions set.");
        }
        return cond;
    }

    public ModelSpecProcessPrototypeRunnableInstructions setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

