/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.model.AffinityConstraint;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableGroup;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.algorithms.GGP;
import org.eclipse.app4mc.multicore.partitioning.utils.CheckActivations;
import org.eclipse.app4mc.multicore.partitioning.utils.CheckLabels;
import org.eclipse.app4mc.multicore.partitioning.utils.CycleElimination;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.partitioning.utils.RemoveGraphEdges;
import org.eclipse.app4mc.multicore.partitioning.utils.RunnableCorePairingToPP;
import org.eclipse.app4mc.multicore.partitioning.utils.TagToPP;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.IPreferenceStore;

public class PrePartitioning {
    private final boolean enableLog = true;
    private boolean activationGroups = false;
    private boolean ggp = false;
    private boolean efficientEdgeInCycle = false;
    private boolean minimalEdgeDis = false;
    private static boolean TAGGROUPS = true;
    private static boolean COREGROUPS = false;
    private static boolean APSCONSID = true;

    public PrePartitioning(IPreferenceStore store) {
        this.setActivationGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolActivation"));
        this.setEfficientEdgeInCycle(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolEffEdge"));
        this.setGgp(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolGGP"));
        this.setMinimalEdgeDis(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolMinEdges"));
    }

    public PrePartitioning(boolean ag, boolean ggp, boolean effEdges, boolean minimalEdges) {
        this.setActivationGroups(ag);
        this.setEfficientEdgeInCycle(effEdges);
        this.setGgp(ggp);
        this.setMinimalEdgeDis(minimalEdges);
    }

    public boolean isEfficientEdgeInCycle() {
        return this.efficientEdgeInCycle;
    }

    public boolean isMinimalEdgeDis() {
        return this.minimalEdgeDis;
    }

    public void setMinimalEdgeDis(boolean minimalEdgeDis) {
        this.minimalEdgeDis = minimalEdgeDis;
    }

    public void setEfficientEdgeInCycle(boolean effCycleElim) {
        this.efficientEdgeInCycle = effCycleElim;
    }

    public Amalthea performPrePartitioning(Amalthea modelCopy, IProgressMonitor monitor) {
        if (this.isEnableLog()) {
            PartLog.getInstance().setLogName("PrePartitioning");
        }
        PartLog.getInstance().logSimple("**Starting PrePartitioning**");
        if (modelCopy.getSwModel() == null) {
            PartLog.getInstance().log("No SW Model found. Stopping Prepartitioning", null);
            return null;
        }
        modelCopy = this.mergeRunnablesFromAffntyCnstrnts(modelCopy);
        if (this.activationGroups) {
            PartLog.getInstance().setLogName("Activation Analysis");
            PartLog.getInstance().log("Starting Activations Analysis");
            assert (modelCopy.getSwModel() != null && modelCopy.getStimuliModel() != null);
            CheckActivations ca = new CheckActivations();
            if (modelCopy.getStimuliModel() != null) {
                ca.createPPs(modelCopy.getSwModel(), modelCopy.getStimuliModel(), monitor);
            } else if (modelCopy.getStimuliModel() == null && modelCopy.getSwModel().getActivations() != null) {
                ca.createPPs(modelCopy.getSwModel(), monitor);
            } else {
                PartLog.getInstance().log("Neither stimulation model nor activation within swmodel found. No activation analaysis possible", null);
            }
            assert (ca.getSwmo() != null);
            if (ca.getSwmo() == null || ca.getSwmo().getRunnables().size() < 1) {
                PartLog.getInstance().log("No Runnables at Activation Analysis.", null);
            } else {
                modelCopy.setSwModel(ca.getSwmo());
                modelCopy.setStimuliModel(ca.getStimu());
                PartLog.getInstance().log("Activation Analysis finished. Created ProcessPrototypes: " + ca.getSwmo().getProcessPrototypes().size());
            }
        }
        if (TAGGROUPS) {
            TagToPP tpp = new TagToPP(modelCopy.getSwModel(), modelCopy.getCommonElements());
            tpp.createPPsFromTags();
        }
        if (COREGROUPS) {
            modelCopy.getSwModel().getProcessPrototypes().addAll(new RunnableCorePairingToPP(modelCopy.getSwModel(), modelCopy.getConstraintsModel()).getPPsFromCorePairings());
        }
        if (modelCopy.getConstraintsModel() == null || modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() == 0) {
            CheckLabels cl = new CheckLabels();
            cl.setSwm(modelCopy.getSwModel());
            if (modelCopy.getConstraintsModel() != null) {
                cl.setCMModel(modelCopy.getConstraintsModel());
            }
            cl.run(monitor);
            if (cl.getCMModel() == null || cl.getCMModel().getRunnableSequencingConstraints().size() < 1) {
                PartLog.getInstance().log("No Constraintsmodel / Runnable Sequencing Constraints created! Stopping Prepartitioning.", null);
                return null;
            }
            if (modelCopy.getConstraintsModel() == null) {
                modelCopy.setConstraintsModel(cl.getCMModel());
            } else if (modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() == 0) {
                modelCopy.getConstraintsModel().getRunnableSequencingConstraints().addAll((Collection)cl.getCMModel().getRunnableSequencingConstraints());
            }
            PartLog.getInstance().log("Graph creation (constraint model) finished.");
        } else {
            PartLog.getInstance().log("ConstraintsModel already existing.");
        }
        if (APSCONSID) {
            new RemoveGraphEdges().removeAPSRSCs((EList<RunnableSequencingConstraint>)modelCopy.getConstraintsModel().getRunnableSequencingConstraints(), modelCopy.getSwModel());
        }
        assert (modelCopy.getSwModel() != null);
        assert (modelCopy.getConstraintsModel().getRunnableSequencingConstraints() != null);
        CycleElimination ce = new CycleElimination(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
        ce.setparams(this.efficientEdgeInCycle, this.minimalEdgeDis);
        while (!ce.run(monitor).isOK()) {
        }
        assert (ce.getSwm() != null && ce.getCm() != null);
        if (ce.getSwm() == null) {
            PartLog.getInstance().log("No swmodel available after CycleElimination. Stopping Prepartitioning.", null);
            return null;
        }
        modelCopy.setSwModel(ce.getSwm());
        modelCopy.setConstraintsModel(ce.getCm());
        PartLog.getInstance().log("Cycle elimination finished.");
        if (this.ggp) {
            PartLog.getInstance().setLogName("GG Partitioning");
            PartLog.getInstance().log("Starting to generate ProcessPrototypes for each independent graph (GGP).");
            GGP ggp = new GGP(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
            ggp.build();
            assert (ggp.getCm() != null && ggp.getSwm() != null);
            if (ggp.getCm() == null || ggp.getCm() == null) {
                PartLog.getInstance().log("GGP did not result in swmodel / constraints model. Stopping Prepartitioning.", null);
                return null;
            }
            modelCopy.setSwModel(ggp.getSwm());
            modelCopy.setConstraintsModel(ggp.getCm());
            PartLog.getInstance().log("GGP finished. Created ProcessPrototypes: " + ggp.getSwm().getProcessPrototypes().size());
        }
        new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes());
        PartLog.getInstance().logSimple("**PrePartitioning finished**");
        return modelCopy;
    }

    private Amalthea mergeRunnablesFromAffntyCnstrnts(Amalthea modelCopy) {
        if (modelCopy.getConstraintsModel() != null && modelCopy.getConstraintsModel().getAffinityConstraints() != null && modelCopy.getConstraintsModel().getAffinityConstraints().size() > 0) {
            PartLog.getInstance().log("Found AffinityConstraints, Creating CumulatedRunnables");
            AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
            EList acs = modelCopy.getConstraintsModel().getAffinityConstraints();
            for (AffinityConstraint ac : acs) {
                if (!(ac instanceof RunnablePairingConstraint) || ((RunnablePairingConstraint)ac).getTarget() != null) continue;
                RunnablePairingConstraint rpc = (RunnablePairingConstraint)ac;
                Runnable r = af.createRunnable();
                r.setName("CumulatedRunnable" + modelCopy.getConstraintsModel().getAffinityConstraints().indexOf((Object)ac));
                RunnableGroup rg = rpc.getGroup();
                RunnableEntityGroup reg = (RunnableEntityGroup)rg;
                long instrCum = 0L;
                for (Runnable run : reg.getRunnables()) {
                    instrCum += new Helper().getInstructions(run);
                    BasicEList ril = new BasicEList();
                    for (RunnableItem ri : run.getRunnableItems()) {
                        if (ri instanceof InstructionsConstant || ri instanceof InstructionsDeviation) continue;
                        ril.add((Object)ri);
                    }
                    r.getRunnableItems().addAll((Collection)ril);
                    r.getActivations().add((Object)run.getFirstActivation());
                    r.getTags().addAll((Collection)run.getTags());
                }
                InstructionsConstant ic = af.createInstructionsConstant();
                ic.setValue(instrCum);
                RunnableInstructions runInst = af.createRunnableInstructions();
                runInst.setDefault((Instructions)ic);
                r.getRunnableItems().add((Object)runInst);
                modelCopy.getSwModel().getRunnables().add((Object)r);
                for (Task t : modelCopy.getSwModel().getTasks()) {
                    for (GraphEntryBase geb : t.getCallGraph().getGraphEntries()) {
                        if (!(geb instanceof CallSequence)) continue;
                        BasicEList rtrcs = new BasicEList();
                        CallSequence cs = (CallSequence)geb;
                        for (CallSequenceItem csi : cs.getCalls()) {
                            if (!(csi instanceof TaskRunnableCall)) continue;
                            TaskRunnableCall trc = (TaskRunnableCall)csi;
                            if (!reg.getRunnables().contains((Object)trc.getRunnable())) continue;
                            rtrcs.add((Object)trc);
                        }
                        cs.getCalls().removeAll((Collection)rtrcs);
                    }
                }
                for (ProcessPrototype pp : modelCopy.getSwModel().getProcessPrototypes()) {
                    Iterator trcIt = pp.getRunnableCalls().iterator();
                    BasicEList trcsadd = new BasicEList();
                    while (trcIt.hasNext()) {
                        TaskRunnableCall trc = (TaskRunnableCall)trcIt.next();
                        if (!reg.getRunnables().contains((Object)trc.getRunnable())) continue;
                        trcIt.remove();
                        if (trcsadd.contains((Object)r)) continue;
                        TaskRunnableCall trcnew = af.createTaskRunnableCall();
                        trcnew.setRunnable(r);
                        trcsadd.add((Object)trcnew);
                    }
                    pp.getRunnableCalls().addAll((Collection)trcsadd);
                }
                new Helper().updatePPsFirstLastActParams(modelCopy.getSwModel());
                modelCopy.getSwModel().getRunnables().removeAll((Collection)reg.getRunnables());
            }
        }
        return modelCopy;
    }

    private boolean isEnableLog() {
        return true;
    }

    public boolean getActivationGroups() {
        return this.activationGroups;
    }

    public void setActivationGroups(boolean ActivationGroups) {
        this.activationGroups = ActivationGroups;
    }

    public boolean isGgp() {
        return this.ggp;
    }

    public void setGgp(boolean ggp) {
        this.ggp = ggp;
    }
}

