/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.handlers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.app4mc.amalthea.model.AbstractProcess;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.OrderPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class WriteGraphvizHandler
extends AbstractHandler {
    public void write(SWModel swm, ConstraintsModel cm, String file) {
        Writer output = null;
        try {
            File file2 = new File(file.substring(0, file.lastIndexOf(".")).concat("(" + swm.getProcessPrototypes().size() + ").dot"));
            output = new BufferedWriter(new FileWriter(file2));
            output.write("digraph G { \n");
            int i = 0;
            while (i < swm.getProcessPrototypes().size()) {
                try {
                    output.write("subgraph cluster_" + i + " { \n style=filled; \n color=lightgrey; \n node [style=filled,color=white];\n");
                    output.write(" " + ((ProcessPrototype)swm.getProcessPrototypes().get(i)).getFirstRunnable().getName() + ";\n");
                    int j = 0;
                    while (j < cm.getRunnableSequencingConstraints().size()) {
                        int k = 0;
                        while (k < ((RunnableSequencingConstraint)cm.getRunnableSequencingConstraints().get(i)).getRunnableGroups().size()) {
                            if (((AbstractProcess)((RunnableSequencingConstraint)cm.getRunnableSequencingConstraints().get(j)).getProcessScope().get(0)).equals(swm.getProcessPrototypes().get(i))) {
                                output.write(" " + ((Runnable)((RunnableEntityGroup)((RunnableSequencingConstraint)cm.getRunnableSequencingConstraints().get(j)).getRunnableGroups().get(k)).getRunnables().get(0)).getName() + ";\n");
                            }
                            ++k;
                        }
                        ++j;
                    }
                    output.write(" label = \"ProcessPrototype" + i + '\"' + ";}\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
            i = 0;
            while (i < swm.getProcessPrototypes().size()) {
                int j = 0;
                while (j < ((ProcessPrototype)swm.getProcessPrototypes().get(i)).getOrderPrecedenceSpec().size()) {
                    output.write(" " + ((OrderPrecedenceSpec)((ProcessPrototype)swm.getProcessPrototypes().get(i)).getOrderPrecedenceSpec().get(j)).getOrigin().getName() + "->" + ((OrderPrecedenceSpec)((ProcessPrototype)swm.getProcessPrototypes().get(i)).getOrderPrecedenceSpec().get(j)).getTarget().getName() + ";\n");
                    ++j;
                }
                ++i;
            }
            output.write("}");
            output.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("Graphviz saved.");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IFile file = null;
        if (selection instanceof IStructuredSelection) {
            Object adapter;
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object element = structuredSelection.getFirstElement();
            if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(IFile.class)) instanceof IFile) {
                element = adapter;
            }
            if (element instanceof IFile) {
                try {
                    file = (IFile)element;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (file != null) {
            this.write(UniversalHandler.getInstance().getSwModel(), UniversalHandler.getInstance().getConstraintsModel(), file.getLocation().toString());
        }
        return null;
    }
}

