/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.PeriodicStimulus;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.Stimulus;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;

public class CheckActivations {
    private SWModel swmo;
    private StimuliModel stimu;

    public void createPPs(SWModel swm, StimuliModel Stim, IProgressMonitor monitor) {
        this.stimu = Stim;
        PartLog.getInstance().setLogName("Activation Analysis");
        for (Stimulus stim : Stim.getStimuli()) {
            PeriodicActivation act = AmaltheaFactory.eINSTANCE.createPeriodicActivation();
            act.setName(stim.getName());
            if (stim instanceof PeriodicStimulus) {
                PeriodicStimulus per = (PeriodicStimulus)stim;
                if (per.getRecurrence() != null) {
                    Time t = AmaltheaFactory.eINSTANCE.createTime();
                    t.setUnit(per.getRecurrence().getUnit());
                    t.setValue(per.getRecurrence().getValue());
                    act.setMax(t);
                    Time t2 = AmaltheaFactory.eINSTANCE.createTime();
                    t2.setUnit(per.getRecurrence().getUnit());
                    t2.setValue(per.getRecurrence().getValue());
                    act.setMin(t2);
                }
                if (per.getOffset() != null) {
                    Time t3 = AmaltheaFactory.eINSTANCE.createTime();
                    t3.setUnit(per.getOffset().getUnit());
                    t3.setValue(per.getOffset().getValue());
                    act.setOffset(t3);
                }
            }
            swm.getActivations().add((Object)act);
        }
        for (Task t : swm.getTasks()) {
            for (GraphEntryBase geb : t.getCallGraph().getGraphEntries()) {
                if (!(geb instanceof CallSequence)) continue;
                Activation ref = null;
                for (Activation a : swm.getActivations()) {
                    if (!a.getName().equals(((Stimulus)t.getStimuli().get(0)).getName())) continue;
                    ref = a;
                }
                assert (ref != null);
                for (CallSequenceItem csi : ((CallSequence)geb).getCalls()) {
                    if (!(csi instanceof TaskRunnableCall)) continue;
                    ((TaskRunnableCall)csi).getRunnable().getActivations().add((Object)ref);
                }
            }
        }
        this.createPPs(swm, monitor);
    }

    public void createPPs(SWModel swm, IProgressMonitor monitor) {
        monitor.beginTask("Acitvation Grouping", swm.getActivations().size());
        PartLog.getInstance().setLogName("Activation Analysis");
        if (swm.getActivations().size() != 0) {
            AmaltheaPackage.eINSTANCE.eClass();
            AmaltheaFactory instance = AmaltheaFactory.eINSTANCE;
            PartLog.getInstance().log("There are " + swm.getActivations().size() + " activations.");
            int act = 0;
            while (act < swm.getActivations().size()) {
                monitor.worked(1);
                ProcessPrototype pp = instance.createProcessPrototype();
                pp.setName(((Activation)swm.getActivations().get(act)).getName());
                pp.setActivation((Activation)swm.getActivations().get(act));
                for (Runnable r : swm.getRunnables()) {
                    assert (r.getFirstActivation() != null);
                    if (r.getFirstActivation() != null) {
                        if (!r.getFirstActivation().equals(swm.getActivations().get(act))) continue;
                        TaskRunnableCall trc = instance.createTaskRunnableCall();
                        trc.setRunnable(r);
                        pp.getRunnableCalls().add((Object)trc);
                        continue;
                    }
                    PartLog.getInstance().log("No activation reference found at runnable " + r.getName(), null);
                    return;
                }
                if (pp.getRunnableCalls().size() == 0) {
                    PartLog.getInstance().log("There is an activation that is not referenced by any runnable (will be ignored) " + pp.getActivation().getName(), null);
                } else {
                    swm.getProcessPrototypes().add((Object)pp);
                }
                ++act;
            }
            this.swmo = swm;
        } else {
            PartLog.getInstance().log("No activation found within software model!", null);
        }
    }

    public SWModel getSwmo() {
        return this.swmo;
    }

    public void setSwmo(SWModel swmo) {
        this.swmo = swmo;
    }

    public StimuliModel getStimu() {
        return this.stimu;
    }

    public void setStimu(StimuliModel stimu) {
        this.stimu = stimu;
    }
}

