/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.Collection;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.jgrapht.DirectedGraph;

public class RemoveGraphEdges {
    EList<RunnableSequencingConstraint> RSCs;
    SWModel swm;

    public void setSwm(SWModel swm) {
        this.swm = swm;
    }

    public void setRSCs(EList<RunnableSequencingConstraint> rSCs) {
        this.RSCs = rSCs;
    }

    public void removeAPSEdges(DirectedGraph<Runnable, RunnableSequencingConstraint> graph, SWModel swm) {
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            if (pp.getAccessPrecedenceSpec() == null || pp.getAccessPrecedenceSpec().size() <= 0) continue;
            for (AccessPrecedenceSpec aps : pp.getAccessPrecedenceSpec()) {
                RunnableSequencingConstraint rscrem = this.getRSCfromAPS(aps);
                if (rscrem == null) continue;
                graph.removeEdge((Object)rscrem);
            }
        }
    }

    public void removeAPSRSCs(EList<RunnableSequencingConstraint> eList, SWModel swm) {
        this.setRSCs(eList);
        this.setSwm(swm);
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            if (pp.getAccessPrecedenceSpec() == null || pp.getAccessPrecedenceSpec().size() <= 0) continue;
            for (AccessPrecedenceSpec aps : pp.getAccessPrecedenceSpec()) {
                RunnableSequencingConstraint rscrem = this.getRSCfromAPS(aps);
                if (rscrem == null) continue;
                eList.remove((Object)rscrem);
                PartLog.getInstance().log("Removed RCS " + rscrem.getName() + " due to APS");
            }
        }
        EList<TaskRunnableCall> etrcs = this.getTRCs();
        if (etrcs.size() < swm.getRunnables().size()) {
            ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
            pp.setName("AllRunnables");
            BasicEList alltrcs = new BasicEList();
            for (Runnable r : this.swm.getRunnables()) {
                TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trc.setRunnable(r);
                alltrcs.add((Object)trc);
            }
            pp.getRunnableCalls().addAll((Collection)alltrcs);
            swm.getProcessPrototypes().add((Object)pp);
            PartLog.getInstance().log("Created AllRunnablesPP with " + alltrcs.size() + " TRCs");
        }
    }

    private EList<TaskRunnableCall> getTRCs() {
        BasicEList trcs = new BasicEList();
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            trcs.addAll((Collection)pp.getRunnableCalls());
        }
        return trcs;
    }

    private RunnableSequencingConstraint getRSCfromAPS(AccessPrecedenceSpec aps) {
        assert (this.RSCs != null);
        if (this.RSCs == null) {
            return null;
        }
        for (RunnableSequencingConstraint rsc : this.RSCs) {
            if (!aps.getOrigin().equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || !aps.getTarget().equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
            return rsc;
        }
        return null;
    }
}

