/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.emf.common.util.EList;

public class TagToPP {
    private final SWModel swm;
    private final CommonElements cem;

    public SWModel getSwm() {
        return this.swm;
    }

    public TagToPP(SWModel sw, CommonElements ce) {
        this.swm = sw;
        this.cem = ce;
    }

    public void createPPsFromTags() {
        if (this.cem == null || this.cem.getTags() == null) {
            PartLog.getInstance().log("Either no Tags or no CommonElements model existing", null);
            return;
        }
        if (this.swm == null || this.swm.getRunnables() == null) {
            PartLog.getInstance().log("Either no Runnables or no software model existing", null);
            return;
        }
        if (this.swm.getProcessPrototypes().size() < 1 || this.swm.getProcessPrototypes() == null) {
            ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
            pp.setName("allRunnables");
            for (Runnable r : this.swm.getRunnables()) {
                TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trc.setRunnable(r);
                pp.getRunnableCalls().add((Object)trc);
            }
            this.swm.getProcessPrototypes().add((Object)pp);
        }
        ListIterator it = this.swm.getProcessPrototypes().listIterator();
        block1: while (it.hasNext()) {
            ProcessPrototype pp = (ProcessPrototype)it.next();
            HashMap<Tag, Integer> TagPPIndexMap = new HashMap<Tag, Integer>();
            int currentNoTagIndex = -1;
            ListIterator it2 = pp.getRunnableCalls().listIterator();
            while (it2.hasNext()) {
                TaskRunnableCall trc2;
                TaskRunnableCall trc = (TaskRunnableCall)it2.next();
                if (trc.getRunnable().getTags() == null || trc.getRunnable().getTags().size() == 0) {
                    if (currentNoTagIndex == -1) {
                        currentNoTagIndex = this.swm.getProcessPrototypes().indexOf((Object)pp);
                        continue block1;
                    }
                    trc2 = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                    trc2.setRunnable(trc.getRunnable());
                    ((ProcessPrototype)this.swm.getProcessPrototypes().get(currentNoTagIndex)).getRunnableCalls().add((Object)trc2);
                    it2.remove();
                    continue;
                }
                if (TagPPIndexMap.containsKey(trc.getRunnable().getTags().get(0))) {
                    trc2 = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                    trc2.setRunnable(trc.getRunnable());
                    ((ProcessPrototype)this.swm.getProcessPrototypes().get(((Integer)TagPPIndexMap.get(trc.getRunnable().getTags().get(0))).intValue())).getRunnableCalls().add((Object)trc2);
                    it2.remove();
                    continue;
                }
                ProcessPrototype pp2 = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                pp2.setName(String.valueOf(pp.getName()) + ((Tag)trc.getRunnable().getTags().get(0)).getName());
                if (trc.getRunnable().getFirstActivation() != null) {
                    pp2.setActivation(trc.getRunnable().getFirstActivation());
                }
                TaskRunnableCall trc22 = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trc22.setRunnable(trc.getRunnable());
                pp2.getRunnableCalls().add((Object)trc22);
                it2.remove();
                it.add(pp2);
                TagPPIndexMap.put((Tag)trc.getRunnable().getTags().get(0), this.swm.getProcessPrototypes().indexOf((Object)pp2));
            }
        }
        this.removeEmptyPPs((EList<ProcessPrototype>)this.swm.getProcessPrototypes());
    }

    private void removeEmptyPPs(EList<ProcessPrototype> processPrototypes) {
        Iterator it = processPrototypes.iterator();
        while (it.hasNext()) {
            ProcessPrototype pp = (ProcessPrototype)it.next();
            if (pp.getRunnableCalls().size() >= 1) continue;
            it.remove();
        }
    }
}

