/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.LinkedList;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;

public class TopologicalCalculation {
    private final SWModel swm;
    private LinkedList<Runnable> untreatedCNs;
    private final ConstraintsModel cm;

    public TopologicalCalculation(SWModel swm, ConstraintsModel cm) {
        this.swm = swm;
        this.cm = cm;
    }

    public int calcNodesToSink(Runnable r) {
        int distance = 0;
        LinkedList<Integer> distList = new LinkedList<Integer>();
        LinkedList<Runnable> sinks = this.getSinks();
        LinkedList<RunnableSequencingConstraint> rscs = this.getOrigins(r);
        if (!sinks.contains(r)) {
            int edges = 0;
            while (edges < rscs.size()) {
                Runnable target = (Runnable)((RunnableEntityGroup)rscs.get(edges).getRunnableGroups().get(1)).getRunnables().get(0);
                distList.add(this.calcNodesToSink(target));
                ++edges;
            }
        } else {
            distList.add(0);
        }
        int j = 0;
        while (j < distList.size()) {
            distance = Math.max(distance, (Integer)distList.get(j));
            ++j;
        }
        return ++distance;
    }

    private LinkedList<Runnable> getSinks() {
        LinkedList<Runnable> sinks = new LinkedList<Runnable>();
        LinkedList<Runnable> origins = new LinkedList<Runnable>();
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            origins.add((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0));
        }
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            if (!origins.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)) && !sinks.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) {
                sinks.add((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0));
            }
            if (this.swm.getRunnables().contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
            sinks.add((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0));
        }
        return sinks;
    }

    private LinkedList<RunnableSequencingConstraint> getOrigins(Runnable r) {
        LinkedList<RunnableSequencingConstraint> rscs = new LinkedList<RunnableSequencingConstraint>();
        for (RunnableSequencingConstraint rsc : this.cm.getRunnableSequencingConstraints()) {
            for (Runnable r2 : ((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables()) {
                if (r2.getName() == null || r.getName() == null || !r2.getName().equals(r.getName()) || rscs.contains(rsc)) continue;
                rscs.add(rsc);
            }
        }
        return rscs;
    }

    public Runnable getFarthestNode(int distance) {
        if (this.untreatedCNs == null) {
            this.untreatedCNs = new LinkedList();
            for (Runnable r : this.swm.getRunnables()) {
                this.untreatedCNs.add(r);
            }
        }
        int l = 0;
        Runnable r = null;
        for (ProcessPrototype pp : this.swm.getProcessPrototypes()) {
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                int k;
                if (!this.untreatedCNs.contains(trc.getRunnable()) || (k = this.calcNodesToSink(trc.getRunnable())) <= l || k >= distance) continue;
                l = k;
                r = trc.getRunnable();
            }
        }
        int temp = this.calcNodesToSink(r);
        if (temp > distance && temp != 1) {
            r = null;
        }
        return r;
    }
}

