/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger;

import java.util.ArrayList;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverity;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.ErrorMessageDialog;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.LogView;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.LoggerEntry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ModelSpecLogger {
    private final ArrayList<LoggerEntry> log = new ArrayList();

    public static ModelSpecLogger of() {
        return new ModelSpecLogger();
    }

    public void addEntry(LoggerEntry entry) {
        this.log.add(entry);
    }

    public void printLog() {
        System.out.print(this);
    }

    public String toString() {
        String log = "";
        for (LoggerEntry entry : this.log) {
            log = String.valueOf(log) + " | +- " + entry + "\n";
        }
        return log;
    }

    public void logToConsole(ConsoleOutputHandler con) {
        con.append(this.toString());
    }

    public void flushLog() {
        this.log.clear();
        LogView checkerView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.app4mc.multicore.sharelibs.modelchecker.views.ModelCheckerView");
        if (checkerView != null) {
            checkerView.flush();
        }
    }

    public void logToView() {
        try {
            LogView checkerView = (LogView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.app4mc.multicore.sharelibs.modelchecker.views.ModelCheckerView");
            checkerView.setLog(this.log);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void openMessageBox() {
        switch (this.getHighestLoggedSeverityLevel()) {
            case ERROR: {
                ErrorMessageDialog dialogBox = new ErrorMessageDialog("Error", "Model Checker found error(s) in the model. Please review them. If you want to review them later, all the issues are also stored in the Model Checker View's log.", 1);
                dialogBox.setLog(this.log);
                dialogBox.setSeverity(EntrySeverityLevel.ERROR);
                dialogBox.open();
                break;
            }
            case WARNING: {
                ErrorMessageDialog dialogBox = new ErrorMessageDialog("Warning", "Model Checker found warning(s) in the model. Please review them. If you want to review them later, all the issues are also stored in the Model Checker View's log.", 4);
                dialogBox.setLog(this.log);
                dialogBox.setSeverity(EntrySeverityLevel.WARNING);
                dialogBox.open();
                break;
            }
            default: {
                ErrorMessageDialog dialogBox = new ErrorMessageDialog("Successful", "Process finished successfully!", 2);
                dialogBox.setLog(this.log);
                dialogBox.setSeverity(EntrySeverityLevel.INFO);
                dialogBox.open();
            }
        }
    }

    private EntrySeverityLevel getHighestLoggedSeverityLevel() {
        EntrySeverity severity = EntrySeverity.of(EntrySeverityLevel.OK);
        for (LoggerEntry entry : this.log) {
            if (entry.getSeverity().compareTo(severity) <= 0) continue;
            severity = entry.getSeverity();
        }
        return severity.getSeverityLevel();
    }

    public int getLogSize() {
        return this.log.size();
    }
}

