/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class CommonConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.110 to itea.111 : Executing Common converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.updateEnum_TimeUnit(rootElement);
        this.update_Tag(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_Tag(Element rootElement) {
        List tags = this.helper.getXpathResult(rootElement, ".//componentsModel/tags[not(@type)]|/components:ComponentsModel/tags|.//swModel/tags| /sw:SWModel/tags", Element.class, new Namespace[]{this.helper.getNS_111("components"), this.helper.getNS_111("sw")});
        for (Element tag : tags) {
            String attributeValue = tag.getAttributeValue("tagName");
            tag.removeAttribute("tagName");
            if (attributeValue == null) continue;
            tag.setAttribute("name", attributeValue);
        }
    }

    private void updateEnum_TimeUnit(Element rootElement) {
        StringBuffer timeXpathBuffer = new StringBuffer();
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:SynchronisationConstraint\")]/tolerance[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:ReactionConstraint\")]/minimum[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:ReactionConstraint\")]/maximum[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:DelayConstraint\")]/upper[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:DelayConstraint\")]/lower[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:AgeConstraint\")]/maximum[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:AgeConstraint\")]/minimum[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:RepetitionConstraint\")]/lower[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:RepetitionConstraint\")]/upper[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//timingConstraints[(@xsi:type=\"constraints:RepetitionConstraint\")]/jitter[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//dataAgeConstraints/dataAge[(@xsi:type=\"constraints:DataAgeTime\")]/minimumTime[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//dataAgeConstraints/dataAge[(@xsi:type=\"constraints:DataAgeTime\")]/maximumTime[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//schedulingUnit[(@xsi:type=\"os:SchedulingHWUnit\")]/delay[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//stimuli[(@xsi:type=\"stimuli:Periodic\")]/offset[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//stimuli[(@xsi:type=\"stimuli:Periodic\")]/recurrence[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:Periodic\")]/min[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:Periodic\")]/max[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:Periodic\")]/deadline[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:Periodic\")]/offset[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:SingleActivation\")]/min[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//activations[(@xsi:type=\"sw:SingleActivation\")]/max[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//stimuli[(@xsi:type=\"stimuli:Single\")]/activation[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//stimuli[(@xsi:type=\"stimuli:ArrivalCurve\")]/arrivalCurveEntries/lowerTimeBorder[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//stimuli[(@xsi:type=\"stimuli:ArrivalCurve\")]/arrivalCurveEntries/upperTimeBorder[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//clocks[(@xsi:type=\"stimuli:ClockTriangleFunction\")]/period[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//clocks[(@xsi:type=\"stimuli:ClockSinusFunction\")]/period[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//clocks[(@xsi:type=\"stimuli:ClockMultiplierList\")]/entries/time[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//runnables/deadline[not(@unit)]|/sw:Runnable/deadline[not(@unit)]");
        timeXpathBuffer.append("|");
        timeXpathBuffer.append(".//schedulingUnit[(@xsi:type=\"sw:SchedulingSWUnit\")]/runnable/deadline[not(@unit)]");
        List matchingTimeElements = this.helper.getXpathResult(rootElement, timeXpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("common"), this.helper.getNS_111("stimuli"), this.helper.getNS_111("os"), this.helper.getNS_111("hw"), this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element element : matchingTimeElements) {
            element.setAttribute("unit", "ps");
        }
        StringBuffer signedTimeXpathBuffer = new StringBuffer();
        signedTimeXpathBuffer.append(".//stimuli/stimulusDeviation/lowerBound[(@xsi:type=\"common:SignedTime\") and not(@unit)]");
        signedTimeXpathBuffer.append("|");
        signedTimeXpathBuffer.append(".//stimuli/stimulusDeviation/upperBound[(@xsi:type=\"common:SignedTime\") and not(@unit)]");
        signedTimeXpathBuffer.append("|");
        signedTimeXpathBuffer.append(".//stimuli/stimulusDeviation/distribution/*[(@xsi:type=\"common:SignedTime\") and not(@unit)]");
        signedTimeXpathBuffer.append("|");
        signedTimeXpathBuffer.append(".//clocks[(@xsi:type=\"stimuli:ClockTriangleFunction\")]/shift[not(@unit)]");
        signedTimeXpathBuffer.append("|");
        signedTimeXpathBuffer.append(".//clocks[(@xsi:type=\"stimuli:ClockSinusFunction\")]/shift[not(@unit)]");
        List matchingSignedTimeElements = this.helper.getXpathResult(rootElement, signedTimeXpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("common"), this.helper.getNS_111("stimuli"), this.helper.getGenericNS("xsi")});
        for (Element element : matchingSignedTimeElements) {
            element.setAttribute("unit", "ps");
        }
    }
}

