/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.dialog;

import org.eclipse.app4mc.amalthea.converters.ui.providers.MigrationVersionErrorDataProvider;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.ui.utils.MigrationSettings;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MigrationErrorDialog
extends Dialog {
    private final MigrationSettings migrationSettings;
    private Table table;

    public MigrationErrorDialog(Shell parentShell, MigrationSettings migrationSettings) {
        super(parentShell);
        this.migrationSettings = migrationSettings;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("AMALTHEA Model Migration");
    }

    protected Control createDialogArea(Composite parent) {
        parent.setToolTipText("AMALTHEA Model Migration");
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)parentComposite.getLayout();
        gridLayout.numColumns = 1;
        Composite composite__1 = new Composite(parentComposite, 0);
        composite__1.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite__1.setLayout((Layout)new GridLayout(1, false));
        Label lblModelMigrationIs = new Label(composite__1, 0);
        lblModelMigrationIs.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        lblModelMigrationIs.setText("Model migration stopped as selected model files belong to different versions");
        Composite composite__2 = new Composite(parentComposite, 0);
        composite__2.setLayoutData((Object)new GridData(16384, 128, true, true, 1, 1));
        composite__2.setLayout((Layout)new GridLayout(1, false));
        final TableViewer tableViewer = new TableViewer(composite__2, 68352);
        tableViewer.setColumnProperties(new String[]{"File Name", "Model Version"});
        TableViewerColumn tableColumn_0 = this.createTableViewerColumn(tableViewer, "File Name", 250);
        tableColumn_0.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof MigrationInputFile && ((MigrationInputFile)element).isVersionDifferent()) {
                    cell.setForeground(new Color((Device)Display.getCurrent(), 255, 0, 0));
                }
            }
        });
        this.createTableViewerColumn(tableViewer, "Model Version", 112);
        tableViewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableColumn[] columns = tableViewer.getTable().getColumns();
                int columnWidth = tableViewer.getTable().getClientArea().width / columns.length;
                int index = 0;
                while (index < columns.length) {
                    columns[index].setWidth(columnWidth);
                    ++index;
                }
            }
        });
        MigrationVersionErrorDataProvider dataProvider = new MigrationVersionErrorDataProvider();
        tableViewer.setContentProvider((IContentProvider)dataProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        tableViewer.setInput(this.migrationSettings.getMigModelFiles());
        this.table = tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        GridData gd_table = new GridData(16384, 0x1000000, true, true, 1, 1);
        gd_table.heightHint = 98;
        gd_table.verticalSpan = 2;
        gd_table.widthHint = 362;
        this.table.setLayoutData((Object)gd_table);
        Composite composite__3 = new Composite(parentComposite, 0);
        composite__3.setLayout((Layout)new FormLayout());
        GridData gd_composite_3 = new GridData(16384, 0x1000000, true, true, 1, 1);
        gd_composite_3.widthHint = 407;
        gd_composite_3.verticalSpan = 2;
        composite__3.setLayoutData((Object)gd_composite_3);
        return parentComposite;
    }

    protected Control createButtonBar(Composite parent) {
        return super.createButtonBar(parent);
    }

    private TableViewerColumn createTableViewerColumn(TableViewer tableViewer, String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn(tableViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public MigrationSettings getMigrationSettings() {
        return this.migrationSettings;
    }
}

