/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelDynamicCacheBuilder {
    private final Map<String, Map<String, List<EObject>>> cacheMap = new HashMap<String, Map<String, List<EObject>>>();
    private Object inputSource;
    private boolean isModelChanged = false;

    public ModelDynamicCacheBuilder(Amalthea root) {
        this.inputSource = root;
        this.addModelChangeListener(root, true);
        this.buildCache();
    }

    public ModelDynamicCacheBuilder(ResourceSet resourceSet) {
        this.inputSource = resourceSet;
        this.addModelChangeListener(resourceSet, true);
        this.buildCache();
    }

    private <T extends Notifier> void addModelChangeListener(T inputSourceElement, boolean addModelChangeListener) {
        if (addModelChangeListener) {
            inputSourceElement.eAdapters().add((Object)new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    super.notifyChanged(notification);
                    ModelDynamicCacheBuilder.this.isModelChanged = true;
                }
            });
        }
    }

    private void buildCache() {
        this.cacheMap.clear();
        TreeIterator allContents = null;
        allContents = this.inputSource instanceof EObject ? EcoreUtil.getAllContents((EObject)((EObject)this.inputSource), (boolean)true) : EcoreUtil.getAllContents((ResourceSet)((ResourceSet)this.inputSource), (boolean)true);
        TreeIterator iter = allContents;
        while (iter.hasNext()) {
            HashMap hashMap;
            EObject element = (EObject)iter.next();
            Class<?> elementsClass = element.getClass();
            if (!IReferable.class.isAssignableFrom(elementsClass)) continue;
            if (!this.cacheMap.containsKey(element.eClass().getName())) {
                hashMap = new HashMap();
                this.cacheMap.put(element.eClass().getName(), hashMap);
            }
            if (!this.cacheMap.get(element.eClass().getName()).containsKey(((IReferable)element).getName())) {
                hashMap = (HashMap)this.cacheMap.get(element.eClass().getName());
                hashMap.put(((IReferable)element).getName(), new BasicEList());
            }
            this.cacheMap.get(element.eClass().getName()).get(((IReferable)element).getName()).add(element);
        }
    }

    public <T> List<T> getElementsBasedOnName(String name, Class<T> targetClass) {
        List<EObject> eObject;
        Map<String, List<EObject>> map;
        if (this.isModelChanged) {
            this.buildCache();
            this.isModelChanged = false;
        }
        if ((map = this.cacheMap.get(targetClass.getSimpleName())) != null && (eObject = map.get(name)) != null) {
            return eObject;
        }
        return new ArrayList();
    }

    public <T extends EObject> List<T> getElementsBasedOnRegex(String regexForName, Class<T> targetClass) {
        Map<String, List<EObject>> map;
        if (this.isModelChanged) {
            this.buildCache();
            this.isModelChanged = false;
        }
        if ((map = this.cacheMap.get(targetClass.getSimpleName())) != null) {
            Pattern regexPattern = Pattern.compile(regexForName);
            List matchingKeys = map.keySet().stream().filter(s -> regexPattern.matcher((CharSequence)s).matches()).collect(Collectors.toList());
            if (matchingKeys != null) {
                ArrayList result = new ArrayList();
                for (String key : matchingKeys) {
                    result.addAll(map.get(key));
                }
                return result;
            }
        }
        return new ArrayList();
    }

    public <T> List<T> getElementsBasedOnType(Class<T> targetClass) {
        if (this.isModelChanged) {
            this.buildCache();
            this.isModelChanged = false;
        }
        ArrayList<EObject> resultElements = new ArrayList<EObject>();
        Map<String, List<EObject>> map = this.cacheMap.get(targetClass.getSimpleName());
        if (map != null) {
            int i = 0;
            while (i < map.keySet().size()) {
                List<EObject> eObjects = map.get(i);
                if (eObjects != null) {
                    resultElements.addAll(eObjects);
                }
                ++i;
            }
        }
        return resultElements;
    }
}

