/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.ClearEvent;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Group;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LabelAccessStatistic;
import org.eclipse.app4mc.amalthea.model.MinAvgMaxStatistic;
import org.eclipse.app4mc.amalthea.model.ModeLiteral;
import org.eclipse.app4mc.amalthea.model.ModeSwitch;
import org.eclipse.app4mc.amalthea.model.ModeSwitchEntry;
import org.eclipse.app4mc.amalthea.model.NumericStatistic;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ProbabilitySwitchEntry;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableCall;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableModeSwitch;
import org.eclipse.app4mc.amalthea.model.RunnableProbabilitySwitch;
import org.eclipse.app4mc.amalthea.model.ServerCall;
import org.eclipse.app4mc.amalthea.model.SetEvent;
import org.eclipse.app4mc.amalthea.model.SingleValueStatistic;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.WaitEvent;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;

public class SoftwareUtil {
    public static List<CallSequenceItem> collectCalls(Process process) {
        return SoftwareUtil.collectCalls(process, null, null);
    }

    public static List<CallSequenceItem> collectCalls(Process process, List<ModeLiteral> modes) {
        return SoftwareUtil.collectCalls(process, modes, null);
    }

    public static List<CallSequenceItem> collectCalls(Process process, List<ModeLiteral> modes, Function<CallSequenceItem, Boolean> filter) {
        ArrayList<CallSequenceItem> itemList = new ArrayList<CallSequenceItem>();
        if (process.getCallGraph() != null) {
            SoftwareUtil.collectCallSequenceItems(process.getCallGraph().getGraphEntries(), modes, filter, itemList);
        }
        return itemList;
    }

    private static void collectCallSequenceItems(List<GraphEntryBase> input, List<ModeLiteral> modes, Function<CallSequenceItem, Boolean> filter, List<CallSequenceItem> itemList) {
        for (GraphEntryBase entry : input) {
            if (entry instanceof ProbabilitySwitch) {
                ProbabilitySwitch propSwitch = (ProbabilitySwitch)entry;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectCallSequenceItems(pse.getItems(), modes, filter, itemList);
                }
                continue;
            }
            if (entry instanceof ModeSwitch) {
                ModeSwitch modeSwitch = (ModeSwitch)entry;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, filter, itemList);
                        continue;
                    }
                    if (Collections.disjoint(mse.getValues(), modes)) continue;
                    SoftwareUtil.collectCallSequenceItems(mse.getItems(), modes, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectCallSequenceItems(modeSwitch.getDefaultEntry().getItems(), modes, filter, itemList);
                continue;
            }
            if (!(entry instanceof CallSequence)) continue;
            for (CallSequenceItem item : ((CallSequence)entry).getCalls()) {
                if (filter != null && !filter.apply(item).booleanValue()) continue;
                itemList.add(item);
            }
        }
    }

    public static List<RunnableItem> collectRunnableItems(Runnable runnable) {
        return SoftwareUtil.collectRunnableItems(runnable, null, null);
    }

    public static List<RunnableItem> collectRunnableItems(Runnable runnable, List<ModeLiteral> modes) {
        return SoftwareUtil.collectRunnableItems(runnable, modes, null);
    }

    public static List<RunnableItem> collectRunnableItems(Runnable runnable, List<ModeLiteral> modes, Function<RunnableItem, Boolean> filter) {
        ArrayList<RunnableItem> itemList = new ArrayList<RunnableItem>();
        SoftwareUtil.collectRunnableItems(runnable.getRunnableItems(), modes, filter, itemList);
        return itemList;
    }

    private static void collectRunnableItems(List<RunnableItem> input, List<ModeLiteral> modes, Function<RunnableItem, Boolean> filter, List<RunnableItem> itemList) {
        for (RunnableItem item : input) {
            if (item instanceof Group) {
                SoftwareUtil.collectRunnableItems(((Group)item).getItems(), modes, filter, itemList);
                continue;
            }
            if (item instanceof RunnableProbabilitySwitch) {
                RunnableProbabilitySwitch propSwitch = (RunnableProbabilitySwitch)item;
                for (ProbabilitySwitchEntry pse : propSwitch.getEntries()) {
                    SoftwareUtil.collectRunnableItems(pse.getItems(), modes, filter, itemList);
                }
                continue;
            }
            if (item instanceof RunnableModeSwitch) {
                RunnableModeSwitch modeSwitch = (RunnableModeSwitch)item;
                boolean includeDefault = true;
                for (ModeSwitchEntry mse : modeSwitch.getEntries()) {
                    if (modes == null) {
                        SoftwareUtil.collectRunnableItems(mse.getItems(), modes, filter, itemList);
                        continue;
                    }
                    if (Collections.disjoint(mse.getValues(), modes)) continue;
                    SoftwareUtil.collectRunnableItems(mse.getItems(), modes, filter, itemList);
                    includeDefault = false;
                }
                if (!includeDefault || modeSwitch.getDefaultEntry() == null) continue;
                SoftwareUtil.collectRunnableItems(modeSwitch.getDefaultEntry().getItems(), modes, filter, itemList);
                continue;
            }
            if (filter != null && !filter.apply(item).booleanValue()) continue;
            itemList.add(item);
        }
    }

    public static Set<Label> getAccessedLabelSet(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static List<LabelAccess> getWriteLabelAccessList(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        HashSet<Label> result = new HashSet<Label>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            result.add(((LabelAccess)ri).getData());
        }
        return result;
    }

    public static List<LabelAccess> getReadLabelAccessesList(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            result.add((LabelAccess)ri);
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Runnable runnable, List<ModeLiteral> modeLiterals) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess)) continue;
            if (result.get(((LabelAccess)ri).getData()) != null) {
                ((List)result.get(((LabelAccess)ri).getData())).add((LabelAccess)ri);
                continue;
            }
            ArrayList<LabelAccess> la = new ArrayList<LabelAccess>();
            la.add((LabelAccess)ri);
            result.put(((LabelAccess)ri).getData(), la);
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getLabelAccessStatisticsMap(Runnable runnable, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null) continue;
            result.put(((LabelAccess)ri).getData(), ((LabelAccess)ri).getStatistic());
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getReadLabelAccessStatisticMap(Runnable runnable, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            result.put(((LabelAccess)ri).getData(), ((LabelAccess)ri).getStatistic());
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getWriteLabelAccessStatisticMap(Runnable runnable, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof LabelAccess) || ((LabelAccess)ri).getStatistic() == null || !((LabelAccess)ri).getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            result.put(((LabelAccess)ri).getData(), ((LabelAccess)ri).getStatistic());
        }
        return result;
    }

    public static Set<Label> getAccessedLabelSet(Process process, List<ModeLiteral> modeLiterals) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.addAll(SoftwareUtil.getAccessedLabelSet(r, modeLiterals));
        }
        return result;
    }

    public static Set<Label> getWriteLabelSet(Process process, List<ModeLiteral> modeLiterals) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.addAll(SoftwareUtil.getWriteLabelSet(r, modeLiterals));
        }
        return result;
    }

    public static Set<Label> getReadLabelSet(Process process, List<ModeLiteral> modeLiterals) {
        HashSet<Label> result = new HashSet<Label>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.addAll(SoftwareUtil.getReadLabelSet(r, modeLiterals));
        }
        return result;
    }

    public static List<LabelAccess> getLabelAccessList(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<LabelAccess> result = new ArrayList<LabelAccess>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.addAll(SoftwareUtil.getLabelAccessList(r, modeLiterals));
        }
        return result;
    }

    public static Map<Label, List<LabelAccess>> getLabelToLabelAccessMap(Process process, List<ModeLiteral> modeLiterals) {
        HashMap<Label, List<LabelAccess>> result = new HashMap<Label, List<LabelAccess>>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.putAll(SoftwareUtil.getLabelToLabelAccessMap(r, modeLiterals));
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getLabelAccessStatisticsMap(Process process, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.putAll(SoftwareUtil.getLabelAccessStatisticsMap(r, modeLiterals));
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getReadLabelAccessStatisticMap(Process process, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.putAll(SoftwareUtil.getReadLabelAccessStatisticMap(r, modeLiterals));
        }
        return result;
    }

    public static Map<Label, LabelAccessStatistic> getWriteLabelAccessStatisticMap(Process process, List<ModeLiteral> modeLiterals) {
        HashMap<Label, LabelAccessStatistic> result = new HashMap<Label, LabelAccessStatistic>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.putAll(SoftwareUtil.getWriteLabelAccessStatisticMap(r, modeLiterals));
        }
        return result;
    }

    public static float getLabelReadCount(Label label, Process process, List<ModeLiteral> modeLiterals, RuntimeUtil.TimeType timeType) {
        float reads = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            List<LabelAccess> readLabelAccessesOfRunnable = SoftwareUtil.getReadLabelAccessesList(r, modeLiterals);
            for (LabelAccess la : readLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    reads += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        reads += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        reads += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        reads += (float)stat.getMax();
                    }
                }
            }
        }
        return reads;
    }

    public static float getLabelWriteCount(Label label, Process process, List<ModeLiteral> modeLiterals, RuntimeUtil.TimeType timeType) {
        float writes = 0.0f;
        if (timeType == null) {
            timeType = RuntimeUtil.TimeType.ACET;
        }
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            List<LabelAccess> writeLabelAccessesOfRunnable = SoftwareUtil.getWriteLabelAccessList(r, modeLiterals);
            for (LabelAccess la : writeLabelAccessesOfRunnable) {
                NumericStatistic statistic = la.getStatistic().getValue();
                if (statistic instanceof SingleValueStatistic) {
                    SingleValueStatistic svs = (SingleValueStatistic)statistic;
                    writes += svs.getValue();
                    continue;
                }
                if (!(statistic instanceof MinAvgMaxStatistic)) continue;
                MinAvgMaxStatistic stat = (MinAvgMaxStatistic)statistic;
                switch (timeType) {
                    case ACET: {
                        writes += stat.getAvg();
                        break;
                    }
                    case BCET: {
                        writes += (float)stat.getMin();
                        break;
                    }
                    case WCET: {
                        writes += (float)stat.getMax();
                    }
                }
            }
        }
        return writes;
    }

    public static List<Runnable> getRunnableList(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        List<CallSequenceItem> callItems = SoftwareUtil.collectCalls(process, modeLiterals);
        for (CallSequenceItem call : callItems) {
            if (!(call instanceof TaskRunnableCall)) continue;
            result.add(((TaskRunnableCall)call).getRunnable());
        }
        return result;
    }

    public static Set<Runnable> getRunnableSet(Process process, List<ModeLiteral> modeLiterals) {
        return new HashSet<Runnable>(SoftwareUtil.getRunnableList(process, modeLiterals));
    }

    public static float getLabelAccessCountFromStatistics(LabelAccess labelAcc, RuntimeUtil.TimeType accType) {
        float accesses = 1.0f;
        if (labelAcc.getStatistic() == null) {
            return 1.0f;
        }
        if (labelAcc.getStatistic().getValue() instanceof SingleValueStatistic) {
            accesses = ((SingleValueStatistic)labelAcc.getStatistic().getValue()).getValue();
        } else if (labelAcc.getStatistic().getValue() instanceof MinAvgMaxStatistic) {
            switch (accType) {
                case ACET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                    break;
                }
                case BCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMin();
                    break;
                }
                case WCET: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getMax();
                    break;
                }
                default: {
                    accesses = ((MinAvgMaxStatistic)labelAcc.getStatistic().getValue()).getAvg();
                }
            }
        }
        return accesses;
    }

    public static List<Runnable> getReaderListOfLabel(Label label, List<ModeLiteral> modeLiterals) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.READ)) continue;
            Runnable run = ModelUtil.getParentContainer(la, Runnable.class);
            if (modeLiterals == null || modeLiterals.isEmpty() || !SoftwareUtil.collectRunnableItems(run, modeLiterals).contains(la)) continue;
            result.add(ModelUtil.getParentContainer(la, Runnable.class));
        }
        return result;
    }

    public static List<SetEvent> collectSetEvents(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<SetEvent> result = new ArrayList<SetEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modeLiterals)) {
            if (!(call instanceof SetEvent)) continue;
            result.add((SetEvent)call);
        }
        return result;
    }

    public static List<ClearEvent> collectClearEvents(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<ClearEvent> result = new ArrayList<ClearEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modeLiterals)) {
            if (!(call instanceof ClearEvent)) continue;
            result.add((ClearEvent)call);
        }
        return result;
    }

    public static List<WaitEvent> collectWaitEvents(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<WaitEvent> result = new ArrayList<WaitEvent>();
        for (CallSequenceItem call : SoftwareUtil.collectEventsOfProcess(process, modeLiterals)) {
            if (!(call instanceof WaitEvent)) continue;
            result.add((WaitEvent)call);
        }
        return result;
    }

    public static List<CallSequenceItem> collectEventsOfProcess(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<CallSequenceItem> result = new ArrayList<CallSequenceItem>();
        List<CallSequenceItem> calls = SoftwareUtil.collectCalls(process, modeLiterals);
        for (CallSequenceItem call : calls) {
            if (!(call instanceof ClearEvent) && !(call instanceof SetEvent) && !(call instanceof WaitEvent)) continue;
            result.add(call);
        }
        return result;
    }

    public static Set<Runnable> getReadersSetOfLabel(Label label, List<ModeLiteral> modeLiterals) {
        return new HashSet<Runnable>(SoftwareUtil.getReaderListOfLabel(label, modeLiterals));
    }

    public static List<Runnable> getWriterListOfLabel(Label label, List<ModeLiteral> modeLiterals) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (LabelAccess la : label.getLabelAccesses()) {
            if (!la.getAccess().equals((Object)LabelAccessEnum.WRITE)) continue;
            Runnable run = ModelUtil.getParentContainer(la, Runnable.class);
            if (modeLiterals == null || modeLiterals.isEmpty() || !SoftwareUtil.collectRunnableItems(run, modeLiterals).contains(la)) continue;
            result.add(ModelUtil.getParentContainer(la, Runnable.class));
        }
        return result;
    }

    public static Set<Runnable> getWriterSetOfLabel(Label label, List<ModeLiteral> modeLiterals) {
        return new HashSet<Runnable>(SoftwareUtil.getWriterListOfLabel(label, modeLiterals));
    }

    public static List<Label> getInterTaskCommunication(Process sender, Process receiver, List<ModeLiteral> modeLiterals) {
        ArrayList<Label> result = new ArrayList<Label>();
        result.addAll(SoftwareUtil.getWriteLabelSet(sender, modeLiterals));
        result.retainAll(SoftwareUtil.getReadLabelSet(receiver, modeLiterals));
        return result;
    }

    public static List<Process> getProcesses(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<Process> result = new ArrayList<Process>();
        for (TaskRunnableCall trc : runnable.getTaskRunnableCalls()) {
            Process proc = ModelUtil.getParentContainer(trc, Process.class);
            if (modeLiterals != null && !modeLiterals.isEmpty()) {
                if (!SoftwareUtil.getRunnableList(proc, modeLiterals).contains(runnable)) continue;
                result.add(proc);
                continue;
            }
            result.add(proc);
        }
        return result;
    }

    public static List<Runnable> getRunnableCallParents(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        for (RunnableCall rc : runnable.getRunnableCalls()) {
            Runnable run = ModelUtil.getParentContainer(rc, Runnable.class);
            if (modeLiterals != null && !modeLiterals.isEmpty()) {
                if (!SoftwareUtil.collectRunnableItems(run, modeLiterals).contains(runnable)) continue;
                result.add(run);
                continue;
            }
            result.add(run);
        }
        return result;
    }

    public static List<Runnable> getCalledRunnables(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<Runnable> result = new ArrayList<Runnable>();
        List<RunnableItem> collectRunnableItems = SoftwareUtil.collectRunnableItems(runnable, modeLiterals);
        for (RunnableItem runItem : collectRunnableItems) {
            if (!(runItem instanceof RunnableCall)) continue;
            result.add(((RunnableCall)runItem).getRunnable());
        }
        return result;
    }

    public static List<RunnableInstructions> getRunnableInstructionsList(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableInstructions> result = new ArrayList<RunnableInstructions>();
        List<RunnableItem> runnableItems = SoftwareUtil.collectRunnableItems(runnable, modeLiterals);
        for (RunnableItem ri : runnableItems) {
            if (!(ri instanceof RunnableInstructions)) continue;
            result.add((RunnableInstructions)ri);
        }
        return result;
    }

    public static List<RunnableInstructions> getRunnableInstructionsList(Process process, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableInstructions> result = new ArrayList<RunnableInstructions>();
        List<Runnable> runnableSet = SoftwareUtil.getRunnableList(process, modeLiterals);
        for (Runnable run : runnableSet) {
            result.addAll(SoftwareUtil.getRunnableInstructionsList(run, modeLiterals));
        }
        return result;
    }

    public static List<Instructions> getInstructionsList(Process process, CoreType coreType, List<ModeLiteral> modeLiterals) {
        List<Runnable> runnables = SoftwareUtil.getRunnableList(process, modeLiterals);
        ArrayList<Instructions> result = new ArrayList<Instructions>();
        for (Runnable runnable : runnables) {
            result.addAll(SoftwareUtil.getInstructionsList(runnable, coreType, modeLiterals));
        }
        return result;
    }

    public static List<Instructions> getInstructionsList(Runnable runnable, CoreType coreType, List<ModeLiteral> modeLiterals) {
        ArrayList<Instructions> result = new ArrayList<Instructions>();
        List<RunnableItem> runnableItems = SoftwareUtil.collectRunnableItems(runnable, modeLiterals);
        for (RunnableItem ri : runnableItems) {
            if (!(ri instanceof RunnableInstructions)) continue;
            RunnableInstructions runnableInstruction = (RunnableInstructions)ri;
            if (coreType == null && runnableInstruction.getDefault() != null) {
                result.add(runnableInstruction.getDefault());
                continue;
            }
            if (runnableInstruction.getExtended().get((Object)coreType) != null) {
                result.add((Instructions)runnableInstruction.getExtended().get((Object)coreType));
                continue;
            }
            if (runnableInstruction.getDefault() == null) continue;
            result.add(runnableInstruction.getDefault());
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Process process, List<ModeLiteral> modeLiterals) {
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (Runnable r : SoftwareUtil.getRunnableList(process, modeLiterals)) {
            result.addAll(SoftwareUtil.getServerCallSet(r, modeLiterals));
        }
        return result;
    }

    public static Set<ServerCall> getServerCallSet(Runnable runnable, List<ModeLiteral> modeLiterals) {
        ArrayList<RunnableItem> runItem = new ArrayList<RunnableItem>();
        runItem.addAll(SoftwareUtil.collectRunnableItems(runnable, modeLiterals));
        HashSet<ServerCall> result = new HashSet<ServerCall>();
        for (RunnableItem ri : runItem) {
            if (!(ri instanceof ServerCall)) continue;
            result.add((ServerCall)ri);
        }
        return result;
    }
}

