/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers;

import org.eclipse.app4mc.amalthea.sphinx.ui.editors.SphinxSupportPlugin;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.editor.ExtendedBasicTransactionalFormEditor;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.messages.Messages;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.ModelHitCollector;
import org.eclipse.app4mc.amalthea.sphinx.ui.editors.search.handlers.SearchGUI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SearchAction
extends Action {
    private final ExtendedBasicTransactionalFormEditor editor;

    public SearchAction(StructuredViewer viewer, ExtendedBasicTransactionalFormEditor editor) {
        super(Messages.SearchAction_title, 1);
        this.editor = editor;
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)SphinxSupportPlugin.getPluginId(), (String)"/icons/full/obj16/find.gif"));
        this.setToolTipText(Messages.SearchGUI_title);
    }

    public void run() {
        Object input;
        String searchValue;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        SearchGUI gui = new SearchGUI(window.getShell());
        gui.create();
        if (gui.open() == 0 && (searchValue = gui.getSearchInput()) != null && searchValue.length() > 0 && !searchValue.equals(" ") && (input = this.editor.getEditorInputObject()) != null) {
            EObject model = null;
            if (input instanceof EObject) {
                model = (EObject)input;
            } else if (input instanceof Resource && ((Resource)input).getContents().size() > 0) {
                model = (EObject)((Resource)input).getContents().get(0);
            }
            if (model != null) {
                ModelHitCollector query = new ModelHitCollector(searchValue, model, this.editor.getEditorInput());
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
        }
    }
}

