/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.ECU;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.HwSystem;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Microcontroller;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.MappingModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class MappingModelValidatorTests {
    private MappingModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new MappingModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkCoreReferenceOfCoreAllocation_null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        SchedulerAllocation allocation = AmaltheaFactory.eINSTANCE.createSchedulerAllocation();
        amalthea.setMappingModel(mappingModel);
        mappingModel.getSchedulerAllocation().add((Object)allocation);
        this.issueCreator.issue((EObject)allocation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSchedulerAllocation_Responsibility(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreReferenceOfCoreAllocation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCoreReferenceOfCoreAllocation_notExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        SchedulerAllocation allocation = AmaltheaFactory.eINSTANCE.createSchedulerAllocation();
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        amalthea.setMappingModel(mappingModel);
        mappingModel.getSchedulerAllocation().add((Object)allocation);
        allocation.getResponsibility().add((Object)core);
        this.issueCreator.issue((EObject)allocation, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSchedulerAllocation_Responsibility(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreReferenceOfCoreAllocation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkCoreReferenceOfCoreAllocation_existing() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        HWModel hwModel = AmaltheaFactory.eINSTANCE.createHWModel();
        HwSystem hwSystem = AmaltheaFactory.eINSTANCE.createHwSystem();
        ECU ecu = AmaltheaFactory.eINSTANCE.createECU();
        Microcontroller microcontroller = AmaltheaFactory.eINSTANCE.createMicrocontroller();
        Core core = AmaltheaFactory.eINSTANCE.createCore();
        MappingModel mappingModel = AmaltheaFactory.eINSTANCE.createMappingModel();
        SchedulerAllocation allocation = AmaltheaFactory.eINSTANCE.createSchedulerAllocation();
        amalthea.setHwModel(hwModel);
        hwModel.setSystem(hwSystem);
        hwSystem.getEcus().add((Object)ecu);
        ecu.getMicrocontrollers().add((Object)microcontroller);
        microcontroller.getCores().add((Object)core);
        amalthea.setMappingModel(mappingModel);
        mappingModel.getSchedulerAllocation().add((Object)allocation);
        allocation.getResponsibility().add((Object)core);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkCoreReferenceOfCoreAllocation(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

