/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.validation.ta.checks.impl;

import org.easymock.EasyMock;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Component;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.Semaphore;
import org.eclipse.app4mc.amalthea.model.SemaphoreAccess;
import org.eclipse.app4mc.amalthea.model.SemaphoreEvent;
import org.eclipse.app4mc.amalthea.sphinx.validation.api.IssueCreator;
import org.eclipse.app4mc.amalthea.validation.ta.checks.impl.OSModelValidatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.junit.Before;
import org.junit.Test;

public class OSModelValidatorTests {
    private OSModelValidatorImpl classUnderTest;
    private IssueCreator issueCreator;

    @Before
    public void setUp() {
        this.issueCreator = (IssueCreator)EasyMock.createMock(IssueCreator.class);
        this.classUnderTest = new OSModelValidatorImpl(this.issueCreator);
    }

    @Test
    public void test_checkSemaphore_InitialValue_Negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(-10);
        semaphore.setMaxValue(20);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphore, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphore_InitialValue(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_InitialValue_Zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(0);
        semaphore.setMaxValue(20);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_InitialValue_Positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(10);
        semaphore.setMaxValue(20);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_MaxValue_Negative() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(0);
        semaphore.setMaxValue(-10);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphore, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphore_MaxValue(), new Object[0]);
        this.issueCreator.issue((EObject)semaphore, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphore_MaxValue(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_MaxValue_Zero() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(0);
        semaphore.setMaxValue(0);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphore, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphore_MaxValue(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_MaxValue_Positive() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(0);
        semaphore.setMaxValue(10);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphore_InitialValue_GT_MaxValue() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphore.setInitialValue(2);
        semaphore.setMaxValue(1);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphore, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphore_MaxValue(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphore(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_Components_NotExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ComponentsModel componentsModel = AmaltheaFactory.eINSTANCE.createComponentsModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Component component = AmaltheaFactory.eINSTANCE.createComponent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        componentsModel.getComponents().add((Object)component);
        amalthea.setComponentsModel(componentsModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_Components_Invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ComponentsModel componentsModel = AmaltheaFactory.eINSTANCE.createComponentsModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Component component = AmaltheaFactory.eINSTANCE.createComponent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        component.getSemaphores().add((Object)semaphore);
        componentsModel.getComponents().add((Object)component);
        amalthea.setComponentsModel(componentsModel);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)component, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getComponent_Semaphores(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_Components_Valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        ComponentsModel componentsModel = AmaltheaFactory.eINSTANCE.createComponentsModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Component component = AmaltheaFactory.eINSTANCE.createComponent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        component.getSemaphores().add((Object)semaphore);
        componentsModel.getComponents().add((Object)component);
        amalthea.setComponentsModel(componentsModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreEvent_NotExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        eventModel.getEvents().add((Object)semaphoreEvent);
        amalthea.setEventModel(eventModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Entity(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreEvent_Null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphoreEvent.setEntity(null);
        eventModel.getEvents().add((Object)semaphoreEvent);
        amalthea.setEventModel(eventModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Entity(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreEvent_Invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphoreEvent.setEntity(semaphore);
        eventModel.getEvents().add((Object)semaphoreEvent);
        amalthea.setEventModel(eventModel);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreEvent, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreEvent_Entity(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreEvent_Valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        EventModel eventModel = AmaltheaFactory.eINSTANCE.createEventModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        SemaphoreEvent semaphoreEvent = AmaltheaFactory.eINSTANCE.createSemaphoreEvent();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        semaphoreEvent.setEntity(semaphore);
        eventModel.getEvents().add((Object)semaphoreEvent);
        amalthea.setEventModel(eventModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreAccess_NotExisting() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        SemaphoreAccess semaphoreAccess = AmaltheaFactory.eINSTANCE.createSemaphoreAccess();
        runnable.getRunnableItems().add((Object)semaphoreAccess);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreAccess_Semaphore(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreAccess_Null() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        SemaphoreAccess semaphoreAccess = AmaltheaFactory.eINSTANCE.createSemaphoreAccess();
        semaphoreAccess.setSemaphore(null);
        runnable.getRunnableItems().add((Object)semaphoreAccess);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreAccess_Semaphore(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreAccess_Invalid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        SemaphoreAccess semaphoreAccess = AmaltheaFactory.eINSTANCE.createSemaphoreAccess();
        semaphoreAccess.setSemaphore(semaphore);
        runnable.getRunnableItems().add((Object)semaphoreAccess);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        amalthea.setOsModel(osModel);
        this.issueCreator.issue((EObject)semaphoreAccess, (EStructuralFeature)AmaltheaPackage.eINSTANCE.getSemaphoreAccess_Semaphore(), new Object[0]);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }

    @Test
    public void test_checkSemaphoreReferences_SemaphoreAccess_Valid() {
        Amalthea amalthea = AmaltheaFactory.eINSTANCE.createAmalthea();
        SWModel swModel = AmaltheaFactory.eINSTANCE.createSWModel();
        OSModel osModel = AmaltheaFactory.eINSTANCE.createOSModel();
        Runnable runnable = AmaltheaFactory.eINSTANCE.createRunnable();
        Semaphore semaphore = AmaltheaFactory.eINSTANCE.createSemaphore();
        SemaphoreAccess semaphoreAccess = AmaltheaFactory.eINSTANCE.createSemaphoreAccess();
        semaphoreAccess.setSemaphore(semaphore);
        runnable.getRunnableItems().add((Object)semaphoreAccess);
        swModel.getRunnables().add((Object)runnable);
        amalthea.setSwModel(swModel);
        osModel.getSemaphores().add((Object)semaphore);
        amalthea.setOsModel(osModel);
        EasyMock.replay((Object[])new Object[]{this.issueCreator});
        this.classUnderTest.checkSemaphoreReferences(amalthea);
        EasyMock.verify((Object[])new Object[]{this.issueCreator});
    }
}

