/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.util;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Preemption;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.workflow.base.AmaltheaWorkflow;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class AddSchedulePoints
extends AmaltheaWorkflow {
    public AddSchedulePoints() {
        this.log = Logger.getLogger((String)"AddSchedulePoints");
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        if (this.getAmaltheaModel(ctx).getSwModel() == null) {
            issues.addError((WorkflowComponent)this, "No proper SWModel available!", (Object)this.getModelSlot());
            return;
        }
        if (this.getAmaltheaModel(ctx).getSwModel().getTasks().isEmpty()) {
            issues.addWarning((WorkflowComponent)this, "No Tasks available to check!", (Object)this.getModelSlot());
            return;
        }
        this.log.info((Object)"Starting...");
        for (Task task : this.getAmaltheaModel(ctx).getSwModel().getTasks()) {
            if (task.getCallGraph() == null || !task.getPreemption().equals((Object)Preemption.COOPERATIVE)) continue;
            this.log.info((Object)("Adding schedule points to cooperative Task [" + task.getName() + "]"));
            for (GraphEntryBase graphEntry : task.getCallGraph().getGraphEntries()) {
                if (!(graphEntry instanceof CallSequence)) continue;
                int index = 0;
                ArrayList<Object> tmp = new ArrayList<Object>();
                for (CallSequenceItem callSeqItem : ((CallSequence)graphEntry).getCalls()) {
                    tmp.add(callSeqItem);
                    if (callSeqItem instanceof TaskRunnableCall && index != ((CallSequence)graphEntry).getCalls().size() - 1) {
                        tmp.add(AmaltheaFactory.eINSTANCE.createSchedulePoint());
                    }
                    ++index;
                }
                ((CallSequence)graphEntry).getCalls().clear();
                ((CallSequence)graphEntry).getCalls().addAll(tmp);
            }
        }
        this.log.info((Object)"Finished.");
    }
}

