/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.ComponentsModel;
import org.eclipse.app4mc.amalthea.model.ConfigModel;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.OSModel;
import org.eclipse.app4mc.amalthea.model.PropertyConstraintsModel;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.sphinx.AmaltheaResourceFactory;
import org.eclipse.app4mc.amalthea.workflow.base.AmaltheaWorkflow;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class AmaltheaReader
extends AmaltheaWorkflow {
    private final List<String> fileNames = new ArrayList<String>();

    public AmaltheaReader() {
        this.log = Logger.getLogger((String)"AmaltheaReader");
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.log.info((Object)"Starting reading files...");
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("amxmi", new AmaltheaResourceFactory());
        EcoreUtil.Copier copier = new EcoreUtil.Copier(true, true);
        for (String filename : this.getFileNames()) {
            try {
                this.log.info((Object)("Reading file: " + filename));
                Resource res = resSet.createResource(URI.createURI((String)filename));
                res.load(null);
                Collection tmp = copier.copyAll((Collection)res.getContents());
                for (EObject content : tmp) {
                    if (content instanceof Amalthea) {
                        Amalthea tmpContent = (Amalthea)content;
                        if (tmpContent.getCustomProperties() != null && tmpContent.getCustomProperties().size() > 0) {
                            this.getAmaltheaModel(ctx).getCustomProperties().addAll((Collection)tmpContent.getCustomProperties());
                        }
                        if (tmpContent.getCommonElements() != null) {
                            this.getAmaltheaModel(ctx).setCommonElements(tmpContent.getCommonElements());
                        }
                        if (tmpContent.getComponentsModel() != null) {
                            this.getAmaltheaModel(ctx).setComponentsModel(tmpContent.getComponentsModel());
                        }
                        if (tmpContent.getConfigModel() != null) {
                            this.getAmaltheaModel(ctx).setConfigModel(tmpContent.getConfigModel());
                        }
                        if (tmpContent.getConstraintsModel() != null) {
                            this.getAmaltheaModel(ctx).setConstraintsModel(tmpContent.getConstraintsModel());
                        }
                        if (tmpContent.getEventModel() != null) {
                            this.getAmaltheaModel(ctx).setEventModel(tmpContent.getEventModel());
                        }
                        if (tmpContent.getHwModel() != null) {
                            this.getAmaltheaModel(ctx).setHwModel(tmpContent.getHwModel());
                        }
                        if (tmpContent.getMappingModel() != null) {
                            this.getAmaltheaModel(ctx).setMappingModel(tmpContent.getMappingModel());
                        }
                        if (tmpContent.getOsModel() != null) {
                            this.getAmaltheaModel(ctx).setOsModel(tmpContent.getOsModel());
                        }
                        if (tmpContent.getPropertyConstraintsModel() != null) {
                            this.getAmaltheaModel(ctx).setPropertyConstraintsModel(tmpContent.getPropertyConstraintsModel());
                        }
                        if (tmpContent.getStimuliModel() != null) {
                            this.getAmaltheaModel(ctx).setStimuliModel(tmpContent.getStimuliModel());
                        }
                        if (tmpContent.getSwModel() == null) continue;
                        this.getAmaltheaModel(ctx).setSwModel(tmpContent.getSwModel());
                        continue;
                    }
                    if (content instanceof CommonElements) {
                        this.getAmaltheaModel(ctx).setCommonElements((CommonElements)content);
                        continue;
                    }
                    if (content instanceof ComponentsModel) {
                        this.getAmaltheaModel(ctx).setComponentsModel((ComponentsModel)content);
                        continue;
                    }
                    if (content instanceof ConfigModel) {
                        this.getAmaltheaModel(ctx).setConfigModel((ConfigModel)content);
                        continue;
                    }
                    if (content instanceof ConstraintsModel) {
                        this.getAmaltheaModel(ctx).setConstraintsModel((ConstraintsModel)content);
                        continue;
                    }
                    if (content instanceof EventModel) {
                        this.getAmaltheaModel(ctx).setEventModel((EventModel)content);
                        continue;
                    }
                    if (content instanceof HWModel) {
                        this.getAmaltheaModel(ctx).setHwModel((HWModel)content);
                        continue;
                    }
                    if (content instanceof MappingModel) {
                        this.getAmaltheaModel(ctx).setMappingModel((MappingModel)content);
                        continue;
                    }
                    if (content instanceof OSModel) {
                        this.getAmaltheaModel(ctx).setOsModel((OSModel)content);
                        continue;
                    }
                    if (content instanceof PropertyConstraintsModel) {
                        this.getAmaltheaModel(ctx).setPropertyConstraintsModel((PropertyConstraintsModel)content);
                        continue;
                    }
                    if (content instanceof StimuliModel) {
                        this.getAmaltheaModel(ctx).setStimuliModel((StimuliModel)content);
                        continue;
                    }
                    if (!(content instanceof SWModel)) continue;
                    this.getAmaltheaModel(ctx).setSwModel((SWModel)content);
                }
            }
            catch (IOException e) {
                issues.addError((WorkflowComponent)this, "Error at loading files!", null, (Throwable)e, null);
            }
        }
        copier.copyReferences();
        this.log.info((Object)"Finished.");
    }

    public void checkConfiguration(Issues issues) {
        if (this.fileNames.isEmpty()) {
            issues.addError((WorkflowComponent)this, "No filenames configured to read!");
        }
        super.checkConfiguration(issues);
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public void addFileName(String fileName) {
        this.fileNames.add(fileName);
    }
}

