/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.workflow.ease;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.app4mc.amalthea.workflow.ease.logging.ConsoleAppender;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.WrapToScript;

public class WorkflowModule
extends AbstractScriptModule {
    @WrapToScript
    public void addLoggerToConsole(String loggerName) {
        this.addLoggerToConsole(loggerName, "%d{ISO8601} %-5p [%c]: %m%n");
    }

    @WrapToScript
    public void addLoggerToConsole(String loggerName, String pattern) {
        Logger rootLogger = Logger.getRootLogger();
        Logger logger = rootLogger.getLoggerRepository().getLogger(loggerName);
        Enumeration elemAppender = logger.getAllAppenders();
        boolean hasConsoleAppender = false;
        while (elemAppender.hasMoreElements()) {
            Appender appender = (Appender)elemAppender.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            hasConsoleAppender = true;
        }
        if (!hasConsoleAppender) {
            PatternLayout layout = new PatternLayout(pattern);
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)layout, this.getScriptEngine().getOutputStream());
            logger.addAppender((Appender)consoleAppender);
            logger.setLevel(Level.INFO);
        }
    }

    @WrapToScript
    public void endWorkflow() {
        this.removeConsoleAppenders();
    }

    private void removeConsoleAppenders() {
        Enumeration elementLogger = LogManager.getCurrentLoggers();
        while (elementLogger.hasMoreElements()) {
            Logger logger = (Logger)elementLogger.nextElement();
            Enumeration elemAppender = logger.getAllAppenders();
            while (elemAppender.hasMoreElements()) {
                Appender appender = (Appender)elemAppender.nextElement();
                if (!(appender instanceof ConsoleAppender)) continue;
                logger.removeAppender(appender);
            }
        }
    }
}

