/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.partitioning;

import org.eclipse.app4mc.multicore.dialogs.AbstractGroup;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ParAlgorithmGroup
extends AbstractGroup {
    private final BooleanFieldEditor GCPheck;
    private final IntegerFieldEditor ESSPPartitions;
    private final IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ParAlgorithmGroup.this.updateEnable(event.getNewValue().toString());
        }
    };

    public ParAlgorithmGroup(Composite parent, IPreferenceStore store) {
        super(parent, store);
        GridLayout layout = new GridLayout(2, false);
        this.group.setText("Partitioning Algorithm");
        this.group.setLayoutData((Object)new GridData(768));
        this.group.setLayout((Layout)layout);
        String[][] options = new String[][]{{"Earliest Start Schedule Partitioning (ESSP)", "essp"}, {"Critical Path Partitioning (CPP)", "cpp"}};
        ComboFieldEditor comboBox = new ComboFieldEditor("org.eclipse.app4mc.multicore.partitioning.partAlgorithm", "Select Algorithm: ", options, (Composite)this.group);
        comboBox.fillIntoGrid((Composite)this.group, 2);
        comboBox.setPropertyChangeListener(this.listener);
        this.addField((FieldEditor)comboBox);
        this.ESSPPartitions = new IntegerFieldEditor("org.eclipse.app4mc.multicore.partitioning.intThreads", "&Number of ESSP partitions: ", (Composite)this.group);
        this.ESSPPartitions.setEnabled(true, (Composite)this.group);
        this.ESSPPartitions.fillIntoGrid((Composite)this.group, 2);
        this.addField((FieldEditor)this.ESSPPartitions);
        this.GCPheck = new BooleanFieldEditor("org.eclipse.app4mc.multicore.partitioning.boolGCP", "Define one global critical path (otherwise CP is calculated for all existing partitions)", (Composite)this.group);
        this.GCPheck.fillIntoGrid((Composite)this.group, 2);
        this.addField((FieldEditor)this.GCPheck);
        this.updateEnable(store.getString("org.eclipse.app4mc.multicore.partitioning.partAlgorithm"));
    }

    protected void updateEnable(String partAlg) {
        switch (partAlg) {
            case "essp": {
                this.ESSPPartitions.setEnabled(true, (Composite)this.group);
                this.GCPheck.setEnabled(false, (Composite)this.group);
                break;
            }
            case "cpp": {
                this.ESSPPartitions.setEnabled(false, (Composite)this.group);
                this.GCPheck.setEnabled(true, (Composite)this.group);
                break;
            }
            default: {
                this.ESSPPartitions.setEnabled(true, (Composite)this.group);
                this.GCPheck.setEnabled(false, (Composite)this.group);
            }
        }
    }

    @Override
    public boolean loadDefault() {
        boolean success = super.loadDefault();
        this.updateEnable(this.store.getString("org.eclipse.app4mc.multicore.partitioning.partAlgorithm"));
        return success;
    }
}

