/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.openmapping;

import java.math.BigDecimal;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;

public class OMCore {
    private final Core coreRef;
    private long instructionsPerSecond = -1L;

    public OMCore(Core coreRef) {
        this.coreRef = coreRef;
    }

    public Core getCoreRef() {
        return this.coreRef;
    }

    public long getInstructionsPerSecond() throws MalformedModelException {
        if (this.instructionsPerSecond >= 0L) {
            return this.instructionsPerSecond;
        }
        Prescaler prescaler = this.coreRef.getPrescaler();
        if (prescaler == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its Prescaler.", null);
            return -1L;
        }
        double clockRatio = prescaler.getClockRatio();
        if (clockRatio <= 0.0) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the refered Prescaler of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute clockRatio.", null);
            return -1L;
        }
        Quartz quartz = prescaler.getQuartz();
        if (quartz == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the refered Prescaler of Core '" + this.coreRef.getName() + "' has an invalid or missing reference to Quartz.", null);
            return -1L;
        }
        long frequency = this.getFrequencyHz();
        if (frequency <= 0L) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the refered Quartz of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute frequency.", null);
            return -1L;
        }
        CoreType type = this.coreRef.getCoreType();
        if (type == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its CoreType.", null);
            return -1L;
        }
        float instructionsPerCycle = type.getInstructionsPerCycle();
        if (instructionsPerCycle <= 0.0f) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the refered CoreType of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute instructionsPerCycle.", null);
            return -1L;
        }
        this.instructionsPerSecond = (long)((double)frequency * clockRatio * (double)instructionsPerCycle);
        return this.instructionsPerSecond;
    }

    public long getFrequencyHz() throws MalformedModelException {
        if (this.coreRef == null) {
            throw new MalformedModelException("No core available!");
        }
        if (this.coreRef.getPrescaler() == null) {
            throw new MalformedModelException("No prescaler at core: " + this.coreRef.getName());
        }
        if (this.coreRef.getPrescaler().getQuartz() == null) {
            throw new MalformedModelException("No quartz at prescaler: " + this.coreRef.getPrescaler().getName() + " at core: " + this.coreRef.getName());
        }
        if (this.coreRef.getPrescaler().getQuartz().getFrequency() == null) {
            throw new MalformedModelException("No frequency at quartz: " + this.coreRef.getPrescaler().getQuartz().getName() + " at prescaler: " + this.coreRef.getPrescaler().getName() + " at core: " + this.coreRef.getName());
        }
        BigDecimal frequencyQuartz = AmaltheaServices.convertToHz((Frequency)this.coreRef.getPrescaler().getQuartz().getFrequency());
        if (frequencyQuartz == null) {
            throw new MalformedModelException("Malformed frequency at quartz: " + this.coreRef.getPrescaler().getQuartz() + " at prescaler: " + this.coreRef.getPrescaler().getName() + " at core: " + this.coreRef.getName());
        }
        long frequency = frequencyQuartz.longValue();
        return frequency;
    }

    public boolean equals(Object obj) {
        if (obj instanceof OMCore) {
            OMCore c = (OMCore)obj;
            return this.coreRef.equals(c.getCoreRef());
        }
        return false;
    }

    public String toString() {
        return this.coreRef.getUniqueName();
    }
}

