/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy;

import java.util.function.Supplier;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.ISystemProxy;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SimException;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem.EMMultiCoreSystem;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem.MultiCoreSystem;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem.SimUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerAlgorithm;

public class SystemProxyFactory {
    public static ISystemProxy createSystemProxy(long timeScale, Supplier<ISchedulerAlgorithm> schedulerAlgoFactory) {
        return new MultiCoreSystem(timeScale, schedulerAlgoFactory);
    }

    public static ISystemProxy createEMSystemProxy(long timescale, Supplier<ISchedulerAlgorithm> schedulerAlgoFactory, ExecutionModel m) {
        return new EMMultiCoreSystem(timescale, schedulerAlgoFactory, m);
    }

    public static ISystemProxy createEMSystemProxyFromOMMapping(long timescale, Supplier<ISchedulerAlgorithm> schedulerAlgoFactory, OMMapping omMapping, ExecutionModel m) throws SimException {
        SimUtil.validateModelForSimulation(omMapping);
        ISystemProxy sim = SystemProxyFactory.createEMSystemProxy(timescale, schedulerAlgoFactory, m);
        for (OMAllocation a : omMapping.getAllocationList()) {
            try {
                sim.addTask(a.getCore().getCoreRef().getName(), a.getTask().getTaskRef().getName(), a.calculateProcessingTime(), a.getTask().getPeriod());
            }
            catch (MalformedModelException e) {
                throw new SimException(e.getMessage());
            }
        }
        return sim;
    }
}

