/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.ISystemProxy;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SimException;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem.SimUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerAlgorithm;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerEventListener;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.ISchedulerTask;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.IStepScheduler;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.Barrier;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.ISchedulerBase;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.core.StepScheduler;

public class MultiCoreSystem
implements ISystemProxy {
    private boolean run = false;
    private final Supplier<ISchedulerAlgorithm> schedulerAlgoFactory;
    private Map<String, IStepScheduler> schedulers = new HashMap<String, IStepScheduler>();
    private final long timeScale;
    private boolean interCoreSynch = false;
    private boolean interrupted = false;

    public MultiCoreSystem(long timeScale, Supplier<ISchedulerAlgorithm> schedulerFactory) {
        this.timeScale = timeScale;
        this.schedulerAlgoFactory = schedulerFactory;
    }

    @Override
    public void compute(long time) throws SimException {
        if (!this.run) {
            this.run = true;
            time = SimUtil.scaleRoundUp(time, this.timeScale);
            this.getSchedulers().values().forEach(ISchedulerBase::init);
            if (this.interCoreSynch) {
                this.simulateSynchronous(time);
            } else {
                this.simulateAsynchronous(time);
            }
        } else {
            throw new SimException("Cant run sim more than once!");
        }
    }

    @Override
    public void interruptComputation() {
        this.interrupted = true;
    }

    private void simulateAsynchronous(final long simulationTime) throws SimException {
        int num = this.getSchedulers().size();
        LinkedList<1> cl = new LinkedList<1>();
        for (final Map.Entry<String, IStepScheduler> entry : this.getSchedulers().entrySet()) {
            cl.add(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    long timecount = 0L;
                    while (timecount <= simulationTime) {
                        ((IStepScheduler)entry.getValue()).runTaskOrIdleStep();
                        ((IStepScheduler)entry.getValue()).updateTaskSynchronisation();
                        ((IStepScheduler)entry.getValue()).updateTaskSet();
                        if (MultiCoreSystem.this.interrupted) {
                            return false;
                        }
                        timecount = Math.addExact(timecount, 1L);
                    }
                    return true;
                }
            });
        }
        ExecutorService taskExecutor = Executors.newFixedThreadPool(num > 10 ? 10 : num);
        try {
            List results = taskExecutor.invokeAll(cl);
            taskExecutor = null;
            for (Future result : results) {
                if (((Boolean)result.get()).booleanValue()) continue;
                throw new SimException("Interrupted scheduling!");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new SimException(e.getMessage());
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new SimException(e.getMessage());
        }
    }

    private void simulateSynchronous(long simulationTime) throws SimException {
        long timecount = 0L;
        while (timecount <= simulationTime) {
            this.getSchedulers().values().forEach(IStepScheduler::runTaskOrIdleStep);
            this.getSchedulers().values().forEach(IStepScheduler::updateTaskSynchronisation);
            this.getSchedulers().values().forEach(IStepScheduler::updateTaskSet);
            if (this.interrupted) {
                throw new SimException("Interrupted scheduling!");
            }
            try {
                timecount = Math.addExact(timecount, 1L);
            }
            catch (ArithmeticException e) {
                throw new SimException(e.getMessage());
            }
        }
    }

    protected Map<String, IStepScheduler> getSchedulers() {
        return this.schedulers;
    }

    @Override
    public void addCoreScheduler(String corename) {
        if (!this.getSchedulers().containsKey(corename)) {
            StepScheduler s = new StepScheduler(this.schedulerAlgoFactory.get());
            this.getSchedulers().put(corename, s);
        }
    }

    @Override
    public void addListener(String coreName, ISchedulerEventListener l) {
        this.getSchedulers().get(coreName).addSchedulerEventListener(l);
    }

    @Override
    public void addTask(String core, String name, long wcet, long period) {
        IStepScheduler s = this.getSchedulers().get(core);
        if (s == null) {
            this.addCoreScheduler(core);
            s = this.getSchedulers().get(core);
        }
        wcet = SimUtil.scaleRoundUp(wcet, this.timeScale);
        period = SimUtil.scaleRoundUp(period, this.timeScale);
        s.addTask(name, wcet, period);
    }

    @Override
    public void addTaskPrecedence(String preCore, String preTask, String postCore, String postTask) throws SimException {
        this.addTaskPrecedence(preCore, preTask, Long.MAX_VALUE, postCore, postTask);
    }

    @Override
    public void addTaskPrecedence(String preCore, String preTask, long releaseTime, String postCore, String postTask) throws SimException {
        if (preTask.equals(postTask)) {
            throw new SimException("Precedence on Task " + preTask + ": Self-Transition is not possible!");
        }
        IStepScheduler preCoreScheduler = this.getSchedulers().get(preCore);
        IStepScheduler postCoreScheduler = this.getSchedulers().get(postCore);
        if (preCoreScheduler == null) {
            throw new SimException("No scheduler available for core: " + preCore);
        }
        if (postCoreScheduler == null) {
            throw new SimException("No scheduler available for core: " + postCore);
        }
        ISchedulerTask pre = preCoreScheduler.getTask(preTask);
        ISchedulerTask post = postCoreScheduler.getTask(postTask);
        if (pre == null) {
            throw new SimException("Task " + preTask + " not available!");
        }
        if (post == null) {
            throw new SimException("Task " + postTask + " not available!");
        }
        if (pre.getPeriod() != post.getPeriod()) {
            throw new SimException("Task " + preTask + " and " + postTask + " do not have an equivalent period! Only equal periods are permitted for task precedence!");
        }
        Barrier m = new Barrier();
        m.setName("bar_task_precedence_" + preTask + "->" + postTask);
        if (releaseTime != Long.MAX_VALUE) {
            releaseTime = SimUtil.scaleRoundUp(releaseTime, this.timeScale);
        }
        pre.addOwnedBarrier(m, releaseTime);
        post.addDependentBarrier(m);
        if (!preCore.equals(postCore)) {
            this.interCoreSynch = true;
        }
    }
}

