/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.logic.systemproxy.multicoresystem;

import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.MalformedModelException;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMCore;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMTask;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.SimException;

public class SimUtil {
    public static void validateModelForSimulation(OMMapping mapping) throws SimException {
        SimUtil.validateOnlyPeriodicTasks(mapping);
        try {
            SimUtil.validateUtilizationPerCore(mapping);
        }
        catch (MalformedModelException e) {
            throw new SimException(e.getMessage());
        }
    }

    public static void validateOnlyPeriodicTasks(OMMapping model) throws SimException {
        for (OMAllocation alloc : model.getAllocationList()) {
            long p = alloc.getTask().getPeriod();
            if (p != 0L) continue;
            throw new SimException("Non-periodic or unset period at task: " + alloc.getTask().getTaskRef().getName());
        }
    }

    public static void validateUtilizationPerCore(OMMapping model) throws SimException, MalformedModelException {
        Map<OMCore, List<OMTask>> tasksPerCore = OMUtil.getCoreTaskMap(model.getAllocationList());
        SimUtil.validateUtilizationPerCore(tasksPerCore);
    }

    public static void validateUtilizationPerCore(Map<OMCore, List<OMTask>> model) throws SimException, MalformedModelException {
        for (OMCore c : model.keySet()) {
            double utila = OMUtil.getUtilization(c, model.get(c));
            if (!(utila > 1.0)) continue;
            throw new SimException("Core " + c.getCoreRef().getName() + " has a utilization greater 1 ( " + utila + ").");
        }
    }

    public static long scaleRoundUp(long val, long scale) {
        return val / scale + (long)(val % scale != 0L ? 1 : 0);
    }
}

