/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.simmenu.wizards;

import java.text.DecimalFormat;
import java.util.stream.Collectors;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMAllocation;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMMapping;
import org.eclipse.app4mc.multicore.execution.logic.openmapping.OMUtil;
import org.eclipse.app4mc.multicore.execution.logic.systemproxy.scheduler.SchedulerAlgorithmRegister;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TaskVisuSchedulingPage
extends WizardPage {
    private static final String[] SIM_TIME_INCREMENT = new String[]{"ms", "us", "ns", "ps"};
    private static final EMTimeType[] SIM_TIME_SCALE = new EMTimeType[]{EMTimeType.MS, EMTimeType.US, EMTimeType.NS, EMTimeType.PS};
    private Composite container;
    private Text txt_simuntil;
    private Combo cb_schedulerSelection;
    private final OMMapping model;
    private long majorCycle = 0L;
    private long simuntil = 0L;
    private String scheduling = "";
    private EMTimeType timescale;
    private Combo cb_precessionSelection;

    protected TaskVisuSchedulingPage(IEMTraceWidget tw, OMMapping model) {
        super("Task Visualisation: Scheduling");
        this.model = model;
        this.setTitle("Task Visualisation: Scheduling");
        this.setDescription("Setup the scheduling used for the visualisation.");
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.container.setLayout((Layout)layout);
        layout.numColumns = 2;
        this.majorCycle = OMUtil.getMajorCycle(this.model.getAllocationList().stream().map(OMAllocation::getTask).collect(Collectors.toList()));
        Label lbl_majorCycle = new Label(this.container, 0);
        lbl_majorCycle.setText("Major-Cycle / Hyperperiod (ps)");
        DecimalFormat decimalFormat = new DecimalFormat("#,##0");
        String numberAsString = decimalFormat.format(this.majorCycle);
        Label lbl_majorCycleVal = new Label(this.container, 0);
        lbl_majorCycleVal.setText(numberAsString);
        lbl_majorCycleVal.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (TaskVisuSchedulingPage.this.txt_simuntil != null) {
                    TaskVisuSchedulingPage.this.txt_simuntil.setText(String.valueOf(TaskVisuSchedulingPage.this.majorCycle));
                }
            }
        });
        Label lbl_seconds = new Label(this.container, 0);
        lbl_seconds.setText(" ");
        Label lbl_majorCycleVal2 = new Label(this.container, 0);
        lbl_majorCycleVal2.setText(this.psToString(this.majorCycle));
        Label label1 = new Label(this.container, 0);
        label1.setText("Algorithm");
        this.cb_schedulerSelection = new Combo(this.container, 8);
        this.cb_schedulerSelection.setItems(SchedulerAlgorithmRegister.schedulerList());
        this.cb_schedulerSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = TaskVisuSchedulingPage.this.cb_schedulerSelection.getSelectionIndex();
                if (i != -1) {
                    TaskVisuSchedulingPage.this.scheduling = SchedulerAlgorithmRegister.schedulerList()[i];
                    TaskVisuSchedulingPage.this.setPageComplete(TaskVisuSchedulingPage.this.isReadyToSim());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labeltimeinc = new Label(this.container, 0);
        labeltimeinc.setText("Scale to");
        this.cb_precessionSelection = new Combo(this.container, 8);
        this.cb_precessionSelection.setItems(SIM_TIME_INCREMENT);
        this.cb_precessionSelection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int i = TaskVisuSchedulingPage.this.cb_precessionSelection.getSelectionIndex();
                if (i != -1) {
                    TaskVisuSchedulingPage.this.timescale = SIM_TIME_SCALE[i];
                    TaskVisuSchedulingPage.this.setPageComplete(TaskVisuSchedulingPage.this.isReadyToSim());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label labelCheck = new Label(this.container, 0);
        labelCheck.setText("Simulation-Time (ps)");
        this.txt_simuntil = new Text(this.container, 0);
        this.simuntil = this.majorCycle;
        this.txt_simuntil.setText("" + this.majorCycle);
        this.txt_simuntil.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent ev) {
                String text = ((Text)ev.getSource()).getText();
                try {
                    TaskVisuSchedulingPage.this.simuntil = Long.parseLong(text);
                }
                catch (NumberFormatException numberFormatException) {
                    TaskVisuSchedulingPage.this.simuntil = 0L;
                }
                TaskVisuSchedulingPage.this.setPageComplete(TaskVisuSchedulingPage.this.isReadyToSim());
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(this.isReadyToSim());
    }

    private boolean isReadyToSim() {
        return this.simuntil != 0L && this.cb_schedulerSelection != null && this.cb_schedulerSelection.getSelectionIndex() != -1 && this.cb_precessionSelection != null && this.cb_precessionSelection.getSelectionIndex() != -1;
    }

    private String psToString(long ps) {
        if (ps % 1000L != 0L) {
            return String.valueOf(ps) + " ps";
        }
        if (ps % 1000000L != 0L) {
            return String.valueOf(ps / 1000L) + " ns";
        }
        if (ps % 1000000000L != 0L) {
            return String.valueOf(ps / 1000000L) + " us";
        }
        return String.valueOf(ps / 1000000000L) + " ms";
    }

    public long getSimuntil() {
        return this.simuntil;
    }

    public String getScheduling() {
        return this.scheduling;
    }

    public EMTimeType getTimeScale() {
        return this.timescale;
    }
}

