/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget;

import java.util.function.BiConsumer;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.ExecutionModel;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.misc.EMTimeType;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMCore;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTask;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskEvent;
import org.eclipse.app4mc.multicore.execution.logic.executionmodel.types.EMTaskHistState;
import org.eclipse.app4mc.multicore.execution.ui.widget.emtracewidget.IEMTraceWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.TraceWidget;

public class EMTraceWidget
extends TraceWidget
implements IEMTraceWidget {
    @Override
    public void addExecutionModel(ExecutionModel em) {
        this.reset();
        if (em.getTimeScale() != EMTimeType.NONE) {
            this.setAxisLabels(em.getTimeScale().toString().toLowerCase());
        }
        for (EMCore c : em.getCores().values()) {
            this.addEMCore(c);
        }
        for (EMTask h : em.getTasks().values()) {
            this.addEMTask(h);
            if (h.getStateHistory().size() > 1) {
                for (EMTaskHistState he : h.getStateHistory()) {
                    this.addEMTaskHist(h, he);
                }
            }
            for (EMTask.DeadlineEntry entry : h.getMissedDeadlines()) {
                this.addDeadlineMissed(h, entry);
            }
        }
        em.addTaskHistEntryAddedListener((BiConsumer)new BiConsumer<EMTask, EMTaskHistState>(){

            @Override
            public void accept(EMTask t, EMTaskHistState u) {
                System.out.println("Task: " + t.getName());
                System.out.println("State:" + u.getState());
            }
        });
        em.addTaskAddedListener(this::addEMTask);
        em.addCoreAddedListener(this::addEMCore);
        em.addTaskHistEntryAddedListener(this::addEMTaskHist);
        em.addTaskDeadlineListener(this::addDeadlineMissed);
    }

    private void addEMCore(EMCore c) {
        this.addCore(c.getName());
    }

    private void addEMTask(EMTask t) {
    }

    private void addEMTaskHist(EMTask t, EMTaskHistState e) {
        if (e.getCore() != null) {
            this.addTask(e.getCore().getName(), t.getName());
            switch (e.getState()) {
                case RUNNING: {
                    this.addTaskRunning(e.getCore().getName(), t.getName(), e.getStart(), e.getEnd());
                    break;
                }
                case WAITING: {
                    String note = "\nSuppressor: " + e.getNote();
                    this.addTaskWaiting(e.getCore().getName(), t.getName(), note, e.getStart(), e.getEnd());
                    break;
                }
                case READY: {
                    this.addTaskReady(e.getCore().getName(), t.getName(), e.getStart(), e.getEnd());
                    if (e.getEvent() != EMTaskEvent.ACTIVATE) break;
                    this.addTaskActivation(e.getCore().getName(), t.getName(), e.getStart());
                    break;
                }
                case SUSPENDED: {
                    this.addTaskSuspended(e.getCore().getName(), t.getName(), e.getStart(), e.getEnd());
                }
            }
        }
    }

    private void addDeadlineMissed(EMTask t, EMTask.DeadlineEntry entry) {
        this.addTaskDeadlineMissed(entry.core.getName(), t.getName(), entry.time);
    }
}

