/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;

public class ExtendedRunnable {
    private final Runnable ref;
    private final long numberOfInstructions;

    public ExtendedRunnable(Runnable ref) {
        this.ref = ref;
        this.numberOfInstructions = this.calcInstructions();
    }

    private long calcInstructions() {
        if (this.ref == null) {
            return 0L;
        }
        if (this.ref.getRunnableItems().size() <= 0) {
            UniversalHandler.getInstance().log(" Unexpected SWModel.\nRunnable has an empty RunnableItems list.\nSkipping...", null);
            return 0L;
        }
        for (RunnableItem runnableItem : this.ref.getRunnableItems()) {
            if (runnableItem instanceof RunnableInstructions) {
                RunnableInstructions runnableInstructions = (RunnableInstructions)runnableItem;
                Instructions abstractInstructions = runnableInstructions.getDefault();
                if (abstractInstructions == null) {
                    UniversalHandler.getInstance().log(" Unexpected SWModel.\nInstructions are not set!\nSkipping...", null);
                    return 0L;
                }
                if (abstractInstructions instanceof InstructionsConstant) {
                    InstructionsConstant execCycles = (InstructionsConstant)abstractInstructions;
                    if (execCycles.getValue() <= 0L) {
                        UniversalHandler.getInstance().log(" Unexpected SWModel.\nExecution cycles not set or negative.\nSkipping...", null);
                        return 0L;
                    }
                    return execCycles.getValue();
                }
                if (!(abstractInstructions instanceof InstructionsDeviation)) continue;
                InstructionsDeviation instructions = (InstructionsDeviation)abstractInstructions;
                Deviation deviation = instructions.getDeviation();
                if (deviation == null) {
                    UniversalHandler.getInstance().log(" Unexpected SWModel.\nDeviation in InstructionsDeviation unset.\nSkipping...", null);
                    return 0L;
                }
                Long lowerBound = ((LongObject)deviation.getLowerBound()).getValue();
                Long upperBound = ((LongObject)deviation.getUpperBound()).getValue();
                if (lowerBound <= 0L || upperBound <= 0L) {
                    UniversalHandler.getInstance().log("Unexpected SWModel.\nDeviation not set properly.\nSkipping...", null);
                    return 0L;
                }
                return (lowerBound + upperBound) / 2L;
            }
            UniversalHandler.getInstance().logCon("Debug Info: Skipping " + runnableItem.getClass().toString());
        }
        UniversalHandler.getInstance().log(" Unexpected SWModel.\nRunnable has no Instructions specified.\nSkipping...", null);
        return 0L;
    }

    public long getNumberOfInstructions() {
        return this.numberOfInstructions;
    }

    public Runnable getRunnableRef() {
        return this.ref;
    }
}

