/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreClassifier;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.amalthea.model.Tag;
import org.eclipse.app4mc.multicore.openmapping.model.OMAnnotationElement;
import org.eclipse.app4mc.multicore.openmapping.model.OMCoreClassifier;
import org.eclipse.app4mc.multicore.openmapping.model.OMTag;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;

public class OMCore {
    private final Core coreRef;
    private long instructionsPerSecond = -1L;
    private ArrayList<OMAnnotationElement> referrableAnnotationElements = new ArrayList();

    public OMCore(Core coreRef) {
        this.coreRef = coreRef;
        this.referrableAnnotationElements = this.addAnnotatableElements();
    }

    private ArrayList<OMAnnotationElement> addAnnotatableElements() {
        ArrayList<OMAnnotationElement> out = new ArrayList<OMAnnotationElement>();
        if (this.coreRef.getTags().size() > 0) {
            this.coreRef.getTags().stream().forEach(tag -> {
                boolean bl = out.add(new OMTag((Tag)tag));
            });
        }
        if (this.coreRef.getCoreType() != null) {
            if (this.coreRef.getCoreType().getTags().size() > 0) {
                this.coreRef.getCoreType().getTags().stream().forEach(tag -> {
                    boolean bl = out.add(new OMTag((Tag)tag));
                });
            }
            if (this.coreRef.getCoreType().getClassifiers().size() > 0) {
                this.coreRef.getCoreType().getClassifiers().stream().forEach(coreClassifier -> {
                    boolean bl = out.add(new OMCoreClassifier((CoreClassifier)coreClassifier));
                });
            }
        }
        return out;
    }

    public long getInstructionsPerSecond() {
        if (this.instructionsPerSecond >= 0L) {
            return this.instructionsPerSecond;
        }
        Prescaler prescaler = this.coreRef.getPrescaler();
        if (prescaler == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its Prescaler.", null);
            return -1L;
        }
        double clockRatio = prescaler.getClockRatio();
        if (clockRatio <= 0.0) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Prescaler of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute clockRatio.", null);
            return -1L;
        }
        Quartz quartz = prescaler.getQuartz();
        if (quartz == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Prescaler of Core '" + this.coreRef.getName() + "' has an invalid or missing reference to Quartz.", null);
            return -1L;
        }
        BigDecimal frequencyQuartz = AmaltheaServices.convertToHz((Frequency)quartz.getFrequency());
        long frequency = frequencyQuartz.longValue();
        if (frequency <= 0L) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred Quartz of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute frequency.", null);
            return -1L;
        }
        CoreType type = this.coreRef.getCoreType();
        if (type == null) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, Core '" + this.coreRef.getName() + "' has an invalid or missing reference to its CoreType.", null);
            return -1L;
        }
        float instructionsPerCycle = type.getInstructionsPerCycle();
        if (instructionsPerCycle <= 0.0f) {
            UniversalHandler.getInstance().log("Invalid Hardware Model, the referred CoreType of Core '" + this.coreRef.getName() + "' contains an invalid value in attribute instructionsPerCycle.", null);
            return -1L;
        }
        this.instructionsPerSecond = (long)((double)frequency * clockRatio * (double)instructionsPerCycle);
        return this.instructionsPerSecond;
    }

    public Core getCoreRef() {
        return this.coreRef;
    }

    public ArrayList<OMAnnotationElement> getAnnotationElement() {
        return this.referrableAnnotationElements;
    }

    public String toString() {
        return this.coreRef.getUniqueName();
    }
}

