/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model;

import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.emf.common.util.EList;

public class OMRunnable {
    private final Runnable runnableRef;
    private long instructions = -1L;

    public OMRunnable(Runnable ref) {
        this.runnableRef = ref;
    }

    public Runnable getRunnableRef() {
        return this.runnableRef;
    }

    public long getInstructionCount() {
        if (this.runnableRef == null) {
            return 0L;
        }
        if (this.instructions >= 0L) {
            return this.instructions;
        }
        if (this.runnableRef.getRunnableItems().size() <= 0) {
            UniversalHandler.getInstance().log("Invalid Software Model, Runnable '" + this.runnableRef.getName() + "' contains no RunnableItems.", null);
            return 0L;
        }
        this.instructions = this.parseRunnableItems((EList<RunnableItem>)this.runnableRef.getRunnableItems());
        return this.instructions;
    }

    public String toString() {
        String out = "Runnable:" + this.getRunnableRef().getName() + "(" + this.getInstructionCount() + ")";
        return out;
    }

    private long parseRunnableItems(EList<RunnableItem> runnableItemsList) {
        for (RunnableItem runnableItem : runnableItemsList) {
            if (!(runnableItem instanceof RunnableInstructions)) continue;
            RunnableInstructions runnableInstructions = (RunnableInstructions)runnableItem;
            Instructions abstractInstructions = runnableInstructions.getDefault();
            if (abstractInstructions == null) {
                UniversalHandler.getInstance().log(" Unexpected SWModel.\nInstructions are not set!\nSkipping...", null);
                return 0L;
            }
            if (abstractInstructions instanceof InstructionsConstant) {
                return this.processInstructionsConstant((InstructionsConstant)abstractInstructions);
            }
            if (abstractInstructions instanceof InstructionsDeviation) {
                return this.processInstructionsDeviation((InstructionsDeviation)abstractInstructions);
            }
            UniversalHandler.getInstance().logCon("Debug Info: Skipping " + runnableItem.getClass().toString());
        }
        UniversalHandler.getInstance().log("Invalid Software Model, there has been no number of Instructions specified.", null);
        return 0L;
    }

    private long processInstructionsConstant(InstructionsConstant instructionsConstant) {
        if (instructionsConstant.getValue() <= 0L) {
            UniversalHandler.getInstance().log("Invalid Software Model, InstructionsConstant contains an invalid value (<= 0).", null);
            return 0L;
        }
        return instructionsConstant.getValue();
    }

    private long processInstructionsDeviation(InstructionsDeviation instructionsDeviation) {
        Deviation deviation = instructionsDeviation.getDeviation();
        if (deviation == null) {
            UniversalHandler.getInstance().log("Invalid Software Model, InstructionsDeviation has an invalid or missing containment to its Deviation.", null);
            return 0L;
        }
        Long lowerBound = ((LongObject)deviation.getLowerBound()).getValue();
        Long upperBound = ((LongObject)deviation.getUpperBound()).getValue();
        if (lowerBound <= 0L || upperBound <= 0L) {
            UniversalHandler.getInstance().log("Unexpected SWModel.\nDeviation not set properly.\nSkipping...", null);
            return 0L;
        }
        return (lowerBound + upperBound) / 2L;
    }
}

