/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.ECU;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.FrequencyUnit;
import org.eclipse.app4mc.amalthea.model.Microcontroller;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;
import org.eclipse.emf.common.util.EList;

public class ModelSpecCorePrescaler
extends ModelSpec {
    public static ModelSpecCorePrescaler build() {
        ModelSpecCorePrescaler spec = new ModelSpecCorePrescaler();
        spec.name = spec.specType = "Has Prescaler with ClockRatio > 0 and Quartz";
        return spec;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        EList cores = ((Microcontroller)((ECU)model.getHwModel().getSystem().getEcus().get(0)).getMicrocontrollers().get(0)).getCores();
        for (Core core : cores) {
            Quartz qtz;
            Prescaler ps = core.getPrescaler();
            if (ps == null) {
                this.log("ECU " + core.getName() + " doesn't have a Prescaler set.");
                cond &= false;
                continue;
            }
            if (ps.getClockRatio() <= 0.0) {
                this.log("Prescaler " + ps.getName() + " has clock ratio <= 0.");
                cond &= false;
            }
            if ((qtz = ps.getQuartz()) == null) {
                this.log("Prescaler " + ps.getName() + " doesn't have a Quartz set.");
                cond &= false;
                continue;
            }
            Frequency frq = qtz.getFrequency();
            if (frq == null) {
                this.log("Quartz " + qtz.getName() + " doesn't have a Frequency set.");
                cond &= false;
                continue;
            }
            if (frq.getUnit() == FrequencyUnit._UNDEFINED_) {
                this.log("Quartz " + qtz.getName() + " has frequency without Unit set.");
                cond &= false;
            }
            if (!(frq.getValue() <= 0.0)) continue;
            this.log("Quartz " + qtz.getName() + " has frequency without Value > 0.");
            cond &= false;
        }
        return cond;
    }

    public ModelSpecCorePrescaler setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

