/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.model.specs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelSpec;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.EntrySeverityLevel;

public class ModelSpecProcessPrototypeRunnableActivations
extends ModelSpec {
    public static ModelSpecProcessPrototypeRunnableActivations build() {
        ModelSpecProcessPrototypeRunnableActivations spec = new ModelSpecProcessPrototypeRunnableActivations();
        spec.name = spec.specType = "Process Prototype's Runnables have activations";
        return spec;
    }

    private List<Runnable> getAllRunnablesOfProcessPrototypes(Amalthea model) {
        ArrayList<Runnable> listRun = new ArrayList<Runnable>();
        for (ProcessPrototype procProto : model.getSwModel().getProcessPrototypes()) {
            for (TaskRunnableCall call : procProto.getRunnableCalls()) {
                listRun.add(call.getRunnable());
            }
        }
        return listRun;
    }

    protected boolean checkSpec(Amalthea model) {
        boolean cond = true;
        for (Runnable run : this.getAllRunnablesOfProcessPrototypes(model)) {
            PeriodicActivation perAct;
            Activation act = run.getFirstActivation();
            if (act == null) {
                cond &= false;
                this.log("Runnable " + run.getName() + " doesn't have an activation set.");
                continue;
            }
            if (!(act instanceof PeriodicActivation) || (perAct = (PeriodicActivation)act).getMax() != null || perAct.getMin() != null) continue;
            cond &= false;
            this.log("Runnable " + run.getName() + "'s periodic activation doesn't have a maximum nor minimum set.");
        }
        return cond;
    }

    public ModelSpecProcessPrototypeRunnableActivations setSeverity(EntrySeverityLevel severity) {
        this.severity = severity;
        return this;
    }
}

