/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.visualizer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;

public class OMVisualizer {
    private final OMMapping mapping;
    private final Map<OMCore, CoreElement> allCores = new HashMap<OMCore, CoreElement>();

    public OMVisualizer(OMMapping mapping) {
        this.mapping = mapping;
    }

    public String getASCIIChart() {
        if (this.allCores.size() <= 0) {
            this.fillCache();
        }
        OptionalLong lMaxComputationTime = this.allCores.values().parallelStream().mapToLong(CoreElement::getComputationTime).max();
        assert (lMaxComputationTime != null);
        String output = "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        output = String.valueOf(output) + "| Core              (#Tasks/#Runnables) | Utilization                        (Percentage) | Cycles          | Time (round to 5 fig.) |\n";
        output = String.valueOf(output) + "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        for (Map.Entry<OMCore, CoreElement> e : this.allCores.entrySet()) {
            String name = String.format("%-26s", e.getKey().getCoreRef().getUniqueName());
            String tasks = String.format("%3d", e.getValue().getTasksSize());
            String runnables = String.format("%4d", e.getValue().getScheduledRunnableCount());
            String utilization = this.drawUtilizationBar(e.getValue().getComputationTime(), lMaxComputationTime.getAsLong());
            String cycles = String.format("%-,15d", e.getValue().getScheduledInstructionCount());
            String percentage = String.format("(%3d%%)", (int)(100.0 / (double)lMaxComputationTime.getAsLong() * (double)e.getValue().getComputationTime()));
            String compurationTime = String.format("%,19.5f \ufffds", (double)e.getValue().getComputationTime() / 1000000.0);
            output = String.valueOf(output) + String.format("| %s (%s/%s) | %s %s | %s | %s |\n", name, tasks, runnables, utilization, percentage, cycles, compurationTime);
        }
        output = String.valueOf(output) + "+---------------------------------------+-------------------------------------------------+-----------------+------------------------+\n";
        return output;
    }

    private String drawUtilizationBar(long lComputationTime, long lMaxComputationTime) {
        double curUtilPercentage = 1.0 / (double)lMaxComputationTime * (double)lComputationTime;
        int curUtilAbs = (int)(curUtilPercentage * 40.0);
        String output = "";
        int i = 0;
        while (i < 40) {
            output = i <= curUtilAbs ? String.valueOf(output) + "X" : String.valueOf(output) + " ";
            ++i;
        }
        return output;
    }

    private void fillCache() {
        assert (this.mapping.getAllocationList().size() > 0);
        for (OMAllocation allocation : this.mapping.getAllocationList()) {
            CoreElement c;
            OMCore core = allocation.getCore();
            if (!this.allCores.containsKey(core)) {
                c = new CoreElement(allocation.getCore());
                c.addAllocation(allocation);
                this.allCores.put(core, c);
                continue;
            }
            c = this.allCores.get(core);
            c.addAllocation(allocation);
        }
    }

    private class CoreElement {
        List<OMAllocation> allocations = new LinkedList<OMAllocation>();
        long iScheduledInstructionCount = -1L;
        long iScheduledRunnableCount = -1L;
        long iComputationTime = -1L;

        CoreElement(OMCore core) {
        }

        public void addAllocation(OMAllocation allocation) {
            this.allocations.add(allocation);
        }

        public int getTasksSize() {
            return this.allocations.size();
        }

        public long getScheduledInstructionCount() {
            if (0L > this.iScheduledInstructionCount) {
                this.iScheduledInstructionCount = (long)Math.ceil(this.allocations.parallelStream().mapToDouble(a -> (double)a.getTask().getInstructionCount() / a.getTask().getRecursionFactor()).sum());
            }
            return this.iScheduledInstructionCount;
        }

        public long getScheduledRunnableCount() {
            if (0L > this.iScheduledRunnableCount) {
                this.iScheduledRunnableCount = this.allocations.parallelStream().mapToLong(a -> a.getTask().getRunnableCount()).sum();
            }
            return this.iScheduledRunnableCount;
        }

        public long getComputationTime() {
            if (0L > this.iComputationTime) {
                this.iComputationTime = this.allocations.parallelStream().mapToLong(a -> a.calculateProcessingTime()).sum();
            }
            return this.iComputationTime;
        }
    }
}

