/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.HashSet;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class Path {
    private HashSet<Runnable> runnables;
    public long runtime;

    public Path() {
        this.setRuntime(0L);
        this.runnables = new HashSet();
    }

    public Path(HashSet<Runnable> rl) {
        this.setRunnables(rl);
        this.updateRunTime();
        this.runnables = new HashSet();
    }

    public String getRunStr() {
        StringBuffer sb = new StringBuffer();
        for (Runnable r : this.getRunnables()) {
            sb.append(String.valueOf(r.getName()) + " ");
        }
        return sb.toString();
    }

    public void updateRunTime() {
        long i = 0L;
        for (Runnable r : this.getRunnables()) {
            i += new Helper().getInstructions(r);
        }
        this.runtime = i;
    }

    public HashSet<Runnable> getRunnables() {
        return this.runnables;
    }

    public EList<Runnable> getRunnablesL() {
        BasicEList rl = new BasicEList();
        for (Runnable r : this.runnables) {
            rl.add((Object)r);
        }
        return rl;
    }

    public void setRunnables(HashSet<Runnable> runnables) {
        this.runnables = runnables;
        this.updateRunTime();
    }

    public void setRunnables(EList<Runnable> runnables) {
        this.runnables = (HashSet)runnables;
        this.updateRunTime();
    }

    public long getRuntime() {
        return this.runtime;
    }

    public void setRuntime(long runtime) {
        this.runtime = runtime;
    }
}

