/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.algorithms;

import java.util.Collection;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.multicore.partitioning.algorithms.GGP;
import org.eclipse.app4mc.multicore.partitioning.utils.AsilToPP;
import org.eclipse.app4mc.multicore.partitioning.utils.CheckActivations;
import org.eclipse.app4mc.multicore.partitioning.utils.CheckLabels;
import org.eclipse.app4mc.multicore.partitioning.utils.CycleElimination;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.MergeRunnablePairings;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.partitioning.utils.RemoveGraphEdges;
import org.eclipse.app4mc.multicore.partitioning.utils.RunnableCorePairingToPP;
import org.eclipse.app4mc.multicore.partitioning.utils.TagToPP;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.preference.IPreferenceStore;

public class PrePartitioning {
    private final boolean enableLog = true;
    private boolean activationGroups = false;
    private boolean ggp = false;
    private boolean efficientEdgeInCycle = false;
    private boolean minimalEdgeDis = false;
    private boolean tagGroups = true;
    private boolean rcpGroups = false;
    private boolean asilGroups = false;
    private boolean rpGroups = false;

    public PrePartitioning(IPreferenceStore store) {
        this.setActivationGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolActivation"));
        this.setEfficientEdgeInCycle(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolEffEdge"));
        this.setGgp(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolGGP"));
        this.setMinimalEdgeDis(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolMinEdges"));
        this.setTagGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolTAGS"));
        this.setRcpGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolRCPC"));
        this.setAsilGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolASIL"));
        this.setRpGroups(store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolRPC"));
    }

    public PrePartitioning(boolean ag, boolean ggp, boolean effEdges, boolean minimalEdges) {
        this.setActivationGroups(ag);
        this.setEfficientEdgeInCycle(effEdges);
        this.setGgp(ggp);
        this.setMinimalEdgeDis(minimalEdges);
    }

    public Amalthea performPrePartitioning(Amalthea modelCopy, IProgressMonitor monitor) {
        if (this.isEnableLog()) {
            PartLog.getInstance().setLogName("PrePartitioning");
        }
        PartLog.getInstance().logSimple("**Starting PrePartitioning**");
        if (modelCopy.getSwModel() == null) {
            PartLog.getInstance().log("No SW Model found. Stopping Prepartitioning", null);
            return null;
        }
        if (this.activationGroups) {
            PartLog.getInstance().setLogName("Activation Analysis");
            PartLog.getInstance().log("Starting Activations Analysis");
            assert (modelCopy.getSwModel() != null && modelCopy.getStimuliModel() != null);
            CheckActivations ca = new CheckActivations();
            if (modelCopy.getStimuliModel() != null) {
                ca.createPPs(modelCopy.getSwModel(), modelCopy.getStimuliModel(), monitor);
            } else if (modelCopy.getStimuliModel() == null && modelCopy.getSwModel().getActivations() != null) {
                ca.createPPs(modelCopy.getSwModel(), monitor);
            } else {
                PartLog.getInstance().log("Neither stimulation model nor activation within swmodel found. No activation analaysis possible", null);
            }
            assert (ca.getSwmo() != null);
            if (ca.getSwmo() == null || ca.getSwmo().getRunnables().size() < 1) {
                PartLog.getInstance().log("No Runnables at Activation Analysis.", null);
            } else {
                modelCopy.setSwModel(ca.getSwmo());
                modelCopy.setStimuliModel(ca.getStimu());
                PartLog.getInstance().log("Activation Analysis finished. Created ProcessPrototypes: " + ca.getSwmo().getProcessPrototypes().size());
            }
        }
        if (this.asilGroups) {
            boolean found = false;
            for (Runnable r : modelCopy.getSwModel().getRunnables()) {
                if (r.getAsilLevel() == null) continue;
                found = true;
                break;
            }
            if (found) {
                AsilToPP ac = new AsilToPP(modelCopy.getSwModel());
                ac.createPPsFromASILsSplit();
                PartLog.getInstance().log("ASIL grouping:\n" + new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes()));
            } else {
                PartLog.getInstance().log("No Runnable references an ASIL level. ASIL partitioning stopped.");
            }
        }
        if (this.tagGroups) {
            if (modelCopy.getCommonElements().getTags().size() > 0) {
                TagToPP tpp = new TagToPP(modelCopy.getSwModel(), modelCopy.getCommonElements());
                tpp.createPPsFromTagsSplit();
                PartLog.getInstance().log("Tag grouping:\n" + new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes()));
            } else {
                PartLog.getInstance().log("No Tags found, stopping Runnable Tag partitioning.");
            }
        }
        if (this.rcpGroups) {
            if (modelCopy.getConstraintsModel().getAffinityConstraints().size() > 0) {
                RunnableCorePairingToPP rcp = new RunnableCorePairingToPP(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
                rcp.getPPsFromCorePairingsSplit();
                PartLog.getInstance().log("RCP grouping:\n" + new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes()));
            } else {
                PartLog.getInstance().log("No Affinity Constraints found, stopping Runnable Core Pairing partitioning.");
            }
        }
        if (this.rpGroups) {
            if (modelCopy.getConstraintsModel().getAffinityConstraints().size() > 0) {
                modelCopy = new MergeRunnablePairings().merge(modelCopy);
                PartLog.getInstance().log("RP grouping:\n" + new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes()));
            } else {
                PartLog.getInstance().log("No Affinity Constraints found, stopping Runnable Pairing partitioning.");
            }
        }
        if (modelCopy.getConstraintsModel() == null || modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() == 0) {
            CheckLabels cl = new CheckLabels();
            cl.setSwm(modelCopy.getSwModel());
            if (modelCopy.getConstraintsModel() != null) {
                cl.setCMModel(modelCopy.getConstraintsModel());
            }
            cl.run(monitor);
            if (cl.getCMModel() == null || cl.getCMModel().getRunnableSequencingConstraints().size() < 1) {
                PartLog.getInstance().log("No Constraintsmodel / Runnable Sequencing Constraints created! Stopping Prepartitioning.", null);
                return null;
            }
            if (modelCopy.getConstraintsModel() == null) {
                modelCopy.setConstraintsModel(cl.getCMModel());
            } else if (modelCopy.getConstraintsModel().getRunnableSequencingConstraints().size() == 0) {
                modelCopy.getConstraintsModel().getRunnableSequencingConstraints().addAll((Collection)cl.getCMModel().getRunnableSequencingConstraints());
            }
            PartLog.getInstance().log("Graph creation (constraint model) finished.");
        } else {
            PartLog.getInstance().log("ConstraintsModel already existing.");
        }
        if (this.aPSarepresent((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes())) {
            RemoveGraphEdges rge = new RemoveGraphEdges();
            rge.removeAPSRSCs(modelCopy.getConstraintsModel().getRunnableSequencingConstraints(), modelCopy.getSwModel());
            modelCopy.getConstraintsModel().getRunnableSequencingConstraints().clear();
            modelCopy.getConstraintsModel().getRunnableSequencingConstraints().addAll(rge.getRSCs());
        }
        assert (modelCopy.getSwModel() != null);
        assert (modelCopy.getConstraintsModel().getRunnableSequencingConstraints() != null);
        CycleElimination ce = new CycleElimination(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
        ce.setparams(this.efficientEdgeInCycle, this.minimalEdgeDis);
        while (!ce.run(monitor).isOK()) {
        }
        assert (ce.getSwm() != null && ce.getCm() != null);
        if (ce.getSwm() == null) {
            PartLog.getInstance().log("No swmodel available after CycleElimination. Stopping Prepartitioning.", null);
            return null;
        }
        modelCopy.setSwModel(ce.getSwm());
        modelCopy.setConstraintsModel(ce.getCm());
        PartLog.getInstance().log("Cycle elimination finished.");
        if (this.ggp) {
            PartLog.getInstance().setLogName("GG Partitioning");
            PartLog.getInstance().log("Starting to generate ProcessPrototypes for each independent graph (GGP).");
            GGP ggp = new GGP(modelCopy.getSwModel(), modelCopy.getConstraintsModel());
            ggp.build();
            assert (ggp.getCm() != null && ggp.getSwm() != null);
            if (ggp.getCm() == null || ggp.getCm() == null) {
                PartLog.getInstance().log("GGP did not result in swmodel / constraints model. Stopping Prepartitioning.", null);
                return null;
            }
            modelCopy.setSwModel(ggp.getSwm());
            modelCopy.setConstraintsModel(ggp.getCm());
            PartLog.getInstance().log("GGP finished. Created ProcessPrototypes: " + ggp.getSwm().getProcessPrototypes().size());
        }
        if (new Helper().activationsAreHarmonic((EList<Activation>)modelCopy.getSwModel().getActivations())) {
            PartLog.getInstance().log("Activations in this model are harmonic! This allows a more sophisticated essp algorithm, that splits partitions with regard to their activation parameter!");
        }
        new Helper().writePPs((EList<ProcessPrototype>)modelCopy.getSwModel().getProcessPrototypes());
        PartLog.getInstance().logSimple("**PrePartitioning finished**");
        return modelCopy;
    }

    private boolean aPSarepresent(EList<ProcessPrototype> processPrototypes) {
        for (ProcessPrototype pp : processPrototypes) {
            if (pp.getAccessPrecedenceSpec().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isEnableLog() {
        return true;
    }

    public void setActivationGroups(boolean ActivationGroups) {
        this.activationGroups = ActivationGroups;
    }

    public void setGgp(boolean ggp) {
        this.ggp = ggp;
    }

    public void setTagGroups(boolean tagGroups) {
        this.tagGroups = tagGroups;
    }

    public void setRcpGroups(boolean rcpGroups) {
        this.rcpGroups = rcpGroups;
    }

    public void setAsilGroups(boolean asilGroups) {
        this.asilGroups = asilGroups;
    }

    public void setRpGroups(boolean rpGroups) {
        this.rpGroups = rpGroups;
    }

    public void setMinimalEdgeDis(boolean minimalEdgeDis) {
        this.minimalEdgeDis = minimalEdgeDis;
    }

    public void setEfficientEdgeInCycle(boolean effCycleElim) {
        this.efficientEdgeInCycle = effCycleElim;
    }
}

