/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableOrderType;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CheckLabels {
    private ConstraintsModel CM;
    private SWModel swm;

    public SWModel getSwm() {
        return this.swm;
    }

    public void setSwm(SWModel swm) {
        this.swm = swm;
    }

    public void setCMModel(ConstraintsModel cm) {
        this.CM = cm;
    }

    public ConstraintsModel getCMModel() {
        return this.CM;
    }

    private boolean RSCLReveals(RunnableSequencingConstraint rsc) {
        for (RunnableSequencingConstraint rsc2 : this.CM.getRunnableSequencingConstraints()) {
            if (rsc2.getRunnableGroups().size() != 2 || !((Runnable)((RunnableEntityGroup)rsc2.getRunnableGroups().get(0)).getRunnables().get(0)).equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || !((Runnable)((RunnableEntityGroup)rsc2.getRunnableGroups().get(1)).getRunnables().get(0)).equals(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) continue;
            return true;
        }
        return false;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Performing label access analysis...", this.swm.getRunnables().size());
        PartLog.getInstance().setLogName("RSC Generation");
        AmaltheaFactory factory = AmaltheaFactory.eINSTANCE;
        if (this.CM == null) {
            this.CM = factory.createConstraintsModel();
        }
        for (Runnable r1 : this.swm.getRunnables()) {
            monitor.worked(1);
            for (Runnable r2 : this.swm.getRunnables()) {
                if (r1 == r2 || this.swm.getRunnables().indexOf((Object)r1) >= this.swm.getRunnables().indexOf((Object)r2)) continue;
                for (RunnableItem ri1 : r1.getRunnableItems()) {
                    for (RunnableItem ri2 : r2.getRunnableItems()) {
                        if (!(ri1 instanceof LabelAccess) || !(ri2 instanceof LabelAccess)) continue;
                        LabelAccess la1 = (LabelAccess)ri1;
                        LabelAccess la2 = (LabelAccess)ri2;
                        if (la1.getData() == null || la2.getData() == null || !la1.getData().getName().equals(la2.getData().getName()) || (!la1.getAccess().equals((Object)LabelAccessEnum.READ) || !la2.getAccess().equals((Object)LabelAccessEnum.WRITE)) && (!la1.getAccess().equals((Object)LabelAccessEnum.WRITE) || !la2.getAccess().equals((Object)LabelAccessEnum.READ))) continue;
                        RunnableSequencingConstraint RSC = factory.createRunnableSequencingConstraint();
                        RSC.setOrderType(RunnableOrderType.SUCCESSOR);
                        RunnableEntityGroup prg1 = factory.createRunnableEntityGroup();
                        RunnableEntityGroup prg2 = factory.createRunnableEntityGroup();
                        prg1.getRunnables().add((Object)r1);
                        prg2.getRunnables().add((Object)r2);
                        if (la1.getAccess().equals((Object)LabelAccessEnum.WRITE) && la2.getAccess().equals((Object)LabelAccessEnum.READ)) {
                            RSC.getRunnableGroups().add((Object)prg1);
                            RSC.getRunnableGroups().add((Object)prg2);
                            RSC.setName(String.valueOf(r1.getName()) + "-->" + r2.getName());
                        } else if (la1.getAccess().equals((Object)LabelAccessEnum.READ) && la2.getAccess().equals((Object)LabelAccessEnum.WRITE)) {
                            RSC.getRunnableGroups().add((Object)prg2);
                            RSC.getRunnableGroups().add((Object)prg1);
                            RSC.setName(String.valueOf(r2.getName()) + "-->" + r1.getName());
                        }
                        if (this.RSCLReveals(RSC)) continue;
                        this.CM.getRunnableSequencingConstraints().add((Object)RSC);
                    }
                }
            }
        }
        PartLog.getInstance().log("Label Access Analysis finished and created " + this.CM.getRunnableSequencingConstraints().size() + " RunnableSequencingConstraints.");
        return Status.OK_STATUS;
    }
}

