/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.model.ASILType;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.AffinityConstraint;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.CallSequenceItem;
import org.eclipse.app4mc.amalthea.model.GraphEntryBase;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableGroup;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnablePairingConstraint;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.Helper;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

public class MergeRunnablePairings {
    public Amalthea merge(Amalthea modelCopy) {
        if (modelCopy.getConstraintsModel() != null && modelCopy.getConstraintsModel().getAffinityConstraints() != null && modelCopy.getConstraintsModel().getAffinityConstraints().size() > 0) {
            PartLog.getInstance().log("Found AffinityConstraints, Creating CumulatedRunnables");
            AmaltheaFactory af = AmaltheaFactory.eINSTANCE;
            EList acs = modelCopy.getConstraintsModel().getAffinityConstraints();
            for (AffinityConstraint ac : acs) {
                if (!(ac instanceof RunnablePairingConstraint) || ((RunnablePairingConstraint)ac).getTarget() != null) continue;
                RunnablePairingConstraint rpc = (RunnablePairingConstraint)ac;
                this.ceckConsistency(rpc);
                Runnable r = af.createRunnable();
                r.setName("CumulatedRunnable" + modelCopy.getConstraintsModel().getAffinityConstraints().indexOf((Object)ac));
                RunnableGroup rg = rpc.getGroup();
                RunnableEntityGroup reg = (RunnableEntityGroup)rg;
                long instrCum = 0L;
                for (Runnable run : reg.getRunnables()) {
                    instrCum += new Helper().getInstructions(run);
                    BasicEList ril = new BasicEList();
                    for (RunnableItem ri : run.getRunnableItems()) {
                        if (ri instanceof InstructionsConstant || ri instanceof InstructionsDeviation) continue;
                        ril.add((Object)ri);
                    }
                    r.getRunnableItems().addAll((Collection)ril);
                    r.getActivations().add((Object)run.getFirstActivation());
                    r.getTags().addAll((Collection)run.getTags());
                }
                InstructionsConstant ic = af.createInstructionsConstant();
                ic.setValue(instrCum);
                RunnableInstructions runInst = af.createRunnableInstructions();
                runInst.setDefault((Instructions)ic);
                r.getRunnableItems().add((Object)runInst);
                modelCopy.getSwModel().getRunnables().add((Object)r);
                for (Task t : modelCopy.getSwModel().getTasks()) {
                    for (GraphEntryBase geb : t.getCallGraph().getGraphEntries()) {
                        if (!(geb instanceof CallSequence)) continue;
                        BasicEList rtrcs = new BasicEList();
                        CallSequence cs = (CallSequence)geb;
                        for (CallSequenceItem csi : cs.getCalls()) {
                            if (!(csi instanceof TaskRunnableCall)) continue;
                            TaskRunnableCall trc = (TaskRunnableCall)csi;
                            if (!reg.getRunnables().contains((Object)trc.getRunnable())) continue;
                            rtrcs.add((Object)trc);
                        }
                        cs.getCalls().removeAll((Collection)rtrcs);
                    }
                }
                for (ProcessPrototype pp : modelCopy.getSwModel().getProcessPrototypes()) {
                    Iterator trcIt = pp.getRunnableCalls().iterator();
                    BasicEList trcsadd = new BasicEList();
                    while (trcIt.hasNext()) {
                        TaskRunnableCall trc = (TaskRunnableCall)trcIt.next();
                        if (!reg.getRunnables().contains((Object)trc.getRunnable())) continue;
                        trcIt.remove();
                        if (trcsadd.contains((Object)r)) continue;
                        TaskRunnableCall trcnew = af.createTaskRunnableCall();
                        trcnew.setRunnable(r);
                        trcsadd.add((Object)trcnew);
                    }
                    pp.getRunnableCalls().addAll((Collection)trcsadd);
                }
                new Helper().updatePPsFirstLastActParams(modelCopy.getSwModel());
                modelCopy.getSwModel().getRunnables().removeAll((Collection)reg.getRunnables());
            }
        }
        return modelCopy;
    }

    private void ceckConsistency(RunnablePairingConstraint rpc) {
        RunnableGroup rg = rpc.getGroup();
        RunnableEntityGroup reg = (RunnableEntityGroup)rg;
        HashSet<Activation> as = new HashSet<Activation>();
        HashSet ts = new HashSet();
        HashSet<ASILType> ass = new HashSet<ASILType>();
        for (Runnable r : reg.getRunnables()) {
            if (!as.contains(r.getFirstActivation())) {
                as.add(r.getFirstActivation());
            }
            if (!ts.contains(r.getTags())) {
                ts.addAll(r.getTags());
            }
            if (ass.contains(r.getAsilLevel())) continue;
            ass.add(r.getAsilLevel());
        }
        if (as.size() > 1) {
            PartLog.getInstance().log("Inconsistency: RunnablePairingConstraint " + null != rpc.getName() ? rpc.getName() : " includes " + as.size() + " different activations", null);
        }
        if (ts.size() > 1) {
            PartLog.getInstance().log("Inconsistency: RunnablePairingConstraint " + null != rpc.getName() ? rpc.getName() : " includes " + ts.size() + " different tags", null);
        }
        if (ass.size() > 1) {
            PartLog.getInstance().log("Inconsistency: RunnablePairingConstraint " + null != rpc.getName() ? rpc.getName() : " includes " + as.size() + " different ASIL-levels", null);
        }
        if (as.size() > 1 || ts.size() > 1 || ass.size() > 1) {
            PartLog.getInstance().log("This inconsistency results in tasks with mixed-up references. To resolve this, please carefully check your ASIL, Tag, and Activation references for the pairing constraint" + null != rpc.getName() ? rpc.getName() : "");
        }
    }
}

