/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters080.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters080.impl.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters080.utils.HelperUtils_072_080;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class StimuliConverter
extends AbstractConverter {
    public StimuliConverter() {
        this.helper = HelperUtils_072_080.getInstance();
        this.logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    }

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from 0.7.2 to 0.8.0 : Executing Stimuli converter for model file : " + targetFile.getName()));
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.update_SignedTime(rootElement);
        this.update_SignedTimeObject(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void update_SignedTimeObject(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//customProperties//@xsi:type[.=\"am:SignedTimeObject\"]");
        List types = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Attribute signedTimeObjectAttribute : types) {
            signedTimeObjectAttribute.setValue("am:TimeObject");
        }
    }

    private void update_SignedTime(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./stimuliModel/stimuli/stimulusDeviation//*[@xsi:type=\"am:SignedTime\"]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element signedTimeElement : elements) {
            Attribute attribute = signedTimeElement.getAttribute("type", this.helper.getGenericNS("xsi"));
            if (attribute == null) continue;
            attribute.setValue("am:Time");
        }
    }
}

