/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters111.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters111.utils.CacheEnum;
import org.eclipse.app4mc.amalthea.converters111.utils.HelperUtils_110_111;
import org.eclipse.app4mc.amalthea.converters111.utils.LabelValueProviderRefsCacheBuilder;
import org.eclipse.app4mc.amalthea.converters111.utils.ModeLabelsCacheBuilder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;

public class SwConverter
implements IConverter {
    private final HelperUtils_110_111 helper = HelperUtils_110_111.getInstance();
    private List<ICache> caches;
    private String workingDirectoryLocation;
    boolean isModeLabelCacheUpdated;
    private final Logger logger = LogManager.getLogger((String)"org.eclipse.app4mc.amalthea.modelmigration");
    File targetFile;
    private int modeCount;

    public void convert(File targetFile, Map<File, Document> fileName_documentsMap, List<ICache> caches) throws Exception {
        this.logger.info((Object)("Migration from itea.110 to itea.111 : Executing SW converter for model file : " + targetFile.getName()));
        this.targetFile = targetFile;
        Document root = fileName_documentsMap.get(targetFile);
        if (root == null) {
            return;
        }
        this.caches = caches;
        Element rootElement = root.getRootElement();
        this.helper.updateNameSpaces_to_111(rootElement);
        this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_111("sw")});
        this.workingDirectoryLocation = targetFile.getParentFile().getCanonicalPath();
        this.updateModeLabel_cache(fileName_documentsMap);
        this.updateEnum_WaitEventType(rootElement);
        this.updateEnum_WaitingBehaviour(rootElement);
        this.updateEnum_AccessPrecedenceType(rootElement);
        this.updateEnum_OrderType(rootElement);
        this.updateEnum_LabelAccessEnum(rootElement);
        this.updateEnum_SemaphoreAccessEnum(rootElement);
        this.updateEnum_Preemption(rootElement);
        this.update_SchedulingSWUnit_namespace(rootElement);
        this.update_ModeLabel_References(rootElement);
        this.update_ModeLiteral_References(rootElement);
        this.remove_deadline_attribute(rootElement);
        this.remove_initialValue_Attribute(rootElement);
        fileName_documentsMap.put(targetFile.getCanonicalFile(), root);
    }

    private void updateModeLabel_cache(Map<File, Document> fileName_documentsMap) {
        if (!this.isModeLabelCacheUpdated) {
            for (ICache iCache : this.caches) {
                if (!(iCache instanceof ModeLabelsCacheBuilder)) continue;
                ((ModeLabelsCacheBuilder)iCache).buildCache(fileName_documentsMap);
                this.isModeLabelCacheUpdated = true;
            }
        }
    }

    private Element getModeLabel(File targetFile, String modeLabelName) {
        for (ICache iCache : this.caches) {
            Element element;
            Object NAME_ELEMENT_Map;
            Map cacheMap;
            if (!(iCache instanceof ModeLabelsCacheBuilder) || (cacheMap = (Map)iCache.getCacheMap().get(targetFile)) == null || (NAME_ELEMENT_Map = cacheMap.get(CacheEnum.ELEMENT_NAME.name())) == null || (element = (Element)((Map)NAME_ELEMENT_Map).get(modeLabelName)) == null) continue;
            return element;
        }
        return null;
    }

    private void remove_initialValue_Attribute(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//labels[@initialValue]");
        List initialValue_Attribs = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getGenericNS("xsi")});
        for (Element label : initialValue_Attribs) {
            label.removeAttribute("initialValue");
        }
    }

    private void remove_deadline_attribute(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//isrs[./deadline]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//tasks[./deadline]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//processPrototypes[./deadline]");
        List absProcessElements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        if (absProcessElements.size() == 0) {
            return;
        }
        Element constraintsModelElement = rootElement.getChild("constraintsModel");
        if (constraintsModelElement == null) {
            String name = rootElement.getName();
            if (name.equals("AMALTHEA")) {
                constraintsModelElement = new Element("constraintsModel");
                rootElement.addContent((Content)constraintsModelElement);
                this.helper.addAdditionalNameSpace(rootElement, new Namespace[]{this.helper.getNS_111("constraints")});
            } else {
                System.err.println("constraints model not present, so can't associate deadline to AbstractProcess elements");
                this.logger.error((Object)"Model Migration (1.1.0 to 1.1.1) -> constraints model not present, so can't migrate \"deadline\" attribute of AbstractProcess elements");
                return;
            }
        }
        for (Element absProcessElement : absProcessElements) {
            String deadline_value;
            Attribute nameAttribute = absProcessElement.getAttribute("name");
            Element deadLineElement = absProcessElement.getChild("deadline");
            if (deadLineElement == null) continue;
            String deadline_unit = deadLineElement.getAttributeValue("unit");
            if (deadline_unit == null) {
                deadline_unit = "ps";
            }
            if ((deadline_value = deadLineElement.getAttributeValue("value")) == null) {
                deadline_value = "0";
            }
            String absProcess_xmiID = absProcessElement.getAttributeValue("id", this.helper.getGenericNS("xmi"));
            Element processRequirementElment = new Element("requirements");
            processRequirementElment.setAttribute("type", "constraints:ProcessRequirement", this.helper.getGenericNS("xsi"));
            if (nameAttribute != null) {
                processRequirementElment.setAttribute("name", nameAttribute.getValue());
            }
            processRequirementElment.setAttribute("severity", "Cosmetic");
            if (absProcess_xmiID == null) {
                absProcess_xmiID = EcoreUtil.generateUUID();
                absProcessElement.setAttribute("id", absProcess_xmiID, this.helper.getGenericNS("xmi"));
            }
            processRequirementElment.setAttribute("process", absProcess_xmiID);
            Element limitElement = new Element("limit");
            limitElement.setAttribute("type", "constraints:TimeRequirementLimit", this.helper.getGenericNS("xsi"));
            limitElement.setAttribute("limitType", "UpperLimit");
            limitElement.setAttribute("metric", "ResponseTime");
            Element limitValueElement = new Element("limitValue");
            limitValueElement.setAttribute("value", deadline_value);
            limitValueElement.setAttribute("unit", deadline_unit);
            limitElement.addContent((Content)limitValueElement);
            processRequirementElment.addContent((Content)limitElement);
            constraintsModelElement.addContent((Content)processRequirementElment);
            absProcessElement.removeContent((Content)deadLineElement);
        }
    }

    private void update_ModeLiteral_References(Element rootElement) {
        HashMap<String, Element> element_LiteralMap = new HashMap<String, Element>();
        List swModels = this.helper.getXpathResult(rootElement, ".//swModel|/sw:SWModel", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        if (swModels.size() == 0) {
            System.err.println("sw-model not present, so can't associate individual ModeLiteral values");
            return;
        }
        List entryElements = this.helper.getXpathResult(rootElement, ".//graphEntries[(@xsi:type=\"sw:ModeSwitch\")]/entries", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        Element mode_migElement = null;
        if (entryElements.size() > 0) {
            mode_migElement = new Element("modes");
            mode_migElement.setAttribute("name", "mode_sw_" + this.modeCount++ + "_migration_generated");
            mode_migElement.setAttribute("id", EcoreUtil.generateUUID(), this.helper.getGenericNS("xmi"));
            ((Element)swModels.get(0)).addContent((Content)mode_migElement);
            for (Element entryElement : entryElements) {
                String value;
                boolean literalElementExists;
                Attribute modeSwitchEntry_value_attribute = entryElement.getAttribute("value");
                if (modeSwitchEntry_value_attribute == null) {
                    modeSwitchEntry_value_attribute = new Attribute("value", "0");
                    entryElement.setAttribute(modeSwitchEntry_value_attribute);
                }
                if (literalElementExists = element_LiteralMap.containsKey(value = modeSwitchEntry_value_attribute.getValue())) {
                    Element literalElement = (Element)element_LiteralMap.get(value);
                    String literal_uuid = literalElement.getAttributeValue("id", this.helper.getGenericNS("xmi"));
                    modeSwitchEntry_value_attribute.setValue(literal_uuid);
                    continue;
                }
                Element literals = new Element("literals");
                literals.setAttribute("name", value);
                String literalID = EcoreUtil.generateUUID();
                literals.setAttribute("id", literalID, this.helper.getGenericNS("xmi"));
                mode_migElement.addContent((Content)literals);
                modeSwitchEntry_value_attribute.setValue(literalID);
                element_LiteralMap.put(value, literals);
            }
        }
    }

    private void update_SchedulingSWUnit_namespace(Element rootElement) {
        List schedulingUnits = this.helper.getXpathResult(rootElement, ".//schedulingUnit[(@xsi:type=\"sw:SchedulingSWUnit\")]", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element schedulingUnit : schedulingUnits) {
            Attribute attribute = schedulingUnit.getAttribute("type", this.helper.getGenericNS("xsi"));
            attribute.setValue("os:SchedulingSWUnit");
        }
    }

    private void updateEnum_WaitEventType(Element rootElement) {
        List waitEvents = this.helper.getXpathResult(rootElement, ".//calls[(@xsi:type=\"sw:WaitEvent\") and not(@maskType) ]", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element waitEvent : waitEvents) {
            waitEvent.setAttribute("maskType", "AND");
        }
    }

    private void updateEnum_WaitingBehaviour(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//calls[(@xsi:type=\"sw:WaitEvent\") and  (@waitingBehaviour=\"unspecified\") ]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//runnableItems[(@xsi:type=\"sw:SynchronousServerCall\") and  (@waitingBehaviour=\"unspecified\") ]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//runnableItem[(@xsi:type=\"sw:SynchronousServerCall\") and  (@waitingBehaviour=\"unspecified\") ]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element waitEvent : elements) {
            waitEvent.removeAttribute("waitingBehaviour");
        }
    }

    private void updateEnum_AccessPrecedenceType(Element rootElement) {
        List accessPrecedenceSpecs = this.helper.getXpathResult(rootElement, ".//accessPrecedenceSpec[not(@orderType) ]", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element accessPrecedenceSpec : accessPrecedenceSpecs) {
            accessPrecedenceSpec.setAttribute("orderType", "ignoreWR");
        }
    }

    private void updateEnum_OrderType(Element rootElement) {
        List accessPrecedenceSpecs = this.helper.getXpathResult(rootElement, ".//orderPrecedenceSpec[not(@orderType) ]", Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element accessPrecedenceSpec : accessPrecedenceSpecs) {
            accessPrecedenceSpec.setAttribute("orderType", "order");
        }
    }

    private void updateEnum_LabelAccessEnum(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//runnableItems[(@xsi:type=\"sw:LabelAccess\"  and not(@access))]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//runnableItem[(@xsi:type=\"sw:LabelAccess\"  and not(@access))]");
        List labelAccesss = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element labelAccess : labelAccesss) {
            labelAccess.setAttribute("access", "read");
        }
    }

    private void updateEnum_SemaphoreAccessEnum(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append(".//runnableItems[(@xsi:type=\"sw:SemaphoreAccess\" and not(@accessEnum))]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//runnableItem[(@xsi:type=\"sw:SemaphoreAccess\" and not(@accessEnum))]");
        List semaphoreAccesss = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element semaphoreAccess : semaphoreAccesss) {
            semaphoreAccess.setAttribute("accessEnum", "request");
        }
    }

    private void updateEnum_Preemption(Element rootElement) {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("./sw:SWModel/tasks[not(@preemption)]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//swModel/tasks[not(@preemption)]");
        xpathBuffer.append("|");
        xpathBuffer.append(".//processPrototypes[not(@preemption)]");
        List elements = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Element element : elements) {
            element.setAttribute("preemption", "cooperative");
        }
    }

    private void update_ModeLabel_References(Element rootElement) throws Exception {
        StringBuffer xpathBuffer = new StringBuffer();
        xpathBuffer.append("(.//graphEntries[(@xsi:type=\"sw:LabelSwitch\")]/@label)");
        HashMap<String, String> localMap = new HashMap<String, String>();
        List valueLabelProvidersRefs = this.helper.getXpathResult(rootElement, xpathBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute attribute : valueLabelProvidersRefs) {
            String value = attribute.getValue();
            String modeLabelID = "";
            if (!localMap.containsKey(value)) {
                Element label;
                if (value.contains("//")) {
                    label = this.getLabel(value, true);
                    if (label == null) continue;
                    modeLabelID = this.createModeLabel(label, this.targetFile);
                    localMap.put(value, modeLabelID);
                } else {
                    label = this.getLabel(value, false);
                    if (label == null) continue;
                    modeLabelID = this.createModeLabel(label, this.targetFile);
                    localMap.put(value, modeLabelID);
                }
            } else {
                modeLabelID = (String)localMap.get(value);
            }
            if (modeLabelID == null || modeLabelID.length() <= 0) continue;
            attribute.setValue(modeLabelID);
            attribute.setName("valueProvider");
            Element parent = attribute.getParent();
            parent.removeAttribute("type", this.helper.getGenericNS("xsi"));
            parent.setAttribute("type", "sw:ModeSwitch", this.helper.getGenericNS("xsi"));
        }
        StringBuffer xpathHREFBuffer = new StringBuffer();
        xpathHREFBuffer.append("(.//graphEntries[(@xsi:type=\"sw:LabelSwitch\")]/label/@href)");
        List hRefs = this.helper.getXpathResult(rootElement, xpathHREFBuffer.toString(), Attribute.class, new Namespace[]{this.helper.getNS_111("sw"), this.helper.getGenericNS("xsi")});
        for (Attribute attribute : hRefs) {
            String value = attribute.getValue();
            File referredFile = this.getReferredFile(value);
            String modeLabelID = "";
            if (!localMap.containsKey(value)) {
                Element label = this.getLabelFromHRef(value);
                if (label == null) continue;
                modeLabelID = String.valueOf(value.split("#")[0]) + "#" + this.createModeLabel(label, referredFile);
                localMap.put(value, modeLabelID);
            } else {
                modeLabelID = (String)localMap.get(value);
            }
            if (modeLabelID == null || modeLabelID.length() <= 0) continue;
            attribute.setValue(modeLabelID);
            Element parent = attribute.getParent();
            parent.removeAttribute("type", this.helper.getGenericNS("xsi"));
            parent.setAttribute("type", "sw:ModeLabel", this.helper.getGenericNS("xsi"));
            parent.setName("valueProvider");
            Element graphEntries = parent.getParentElement();
            graphEntries.removeAttribute("type", this.helper.getGenericNS("xsi"));
            graphEntries.setAttribute("type", "sw:ModeSwitch", this.helper.getGenericNS("xsi"));
        }
    }

    private File getReferredFile(String value) throws IOException {
        String[] split = value.split("#");
        if (split.length != 2) {
            return null;
        }
        String refFileName = split[0];
        String referencedFilePath = String.valueOf(this.workingDirectoryLocation) + File.separator + refFileName;
        File referenceFile = new File(referencedFilePath).getCanonicalFile();
        return referenceFile;
    }

    private Element getLabelFromHRef(String labelReference_with_fileName) throws Exception {
        boolean iURIFragment = false;
        String[] split = labelReference_with_fileName.split("#");
        if (split.length != 2) {
            return null;
        }
        String refFileName = split[0];
        String labelReference = split[1];
        if (labelReference.contains("//")) {
            iURIFragment = true;
        }
        if (iURIFragment) {
            for (ICache iCache : this.caches) {
                if (!(iCache instanceof LabelValueProviderRefsCacheBuilder)) continue;
                Set fileSet = iCache.getCacheMap().keySet();
                for (File file : fileSet) {
                    Map cacheMap = (Map)iCache.getCacheMap().get(file);
                    Object HREF_URIFRAGMENT_ELEMENT_Map = cacheMap.get(CacheEnum.HREF_URIFRAGMENT_ELEMENT.name());
                    Element element = (Element)((Map)HREF_URIFRAGMENT_ELEMENT_Map).get(labelReference_with_fileName);
                    if (element == null) continue;
                    return element;
                }
            }
        } else {
            String referencedFilePath = String.valueOf(this.workingDirectoryLocation) + File.separator + refFileName;
            File referenceFile = new File(referencedFilePath).getCanonicalFile();
            List filteredCaches = this.getFilteredCaches(this.caches, new Class[]{LabelValueProviderRefsCacheBuilder.class});
            for (LabelValueProviderRefsCacheBuilder labelValueProviderRefsCacheBuilder : filteredCaches) {
                Object UUID_ELEMENT_Map;
                Element element;
                Map cacheMap;
                if (iURIFragment || (cacheMap = (Map)labelValueProviderRefsCacheBuilder.getCacheMap().get(referenceFile)) == null || (element = (Element)((Map)(UUID_ELEMENT_Map = cacheMap.get(CacheEnum.UUID_ELEMENT.name()))).get(labelReference)) == null) continue;
                return element;
            }
        }
        return null;
    }

    private Element getLabel(String labelReference, boolean iURIFragment) {
        for (ICache iCache : this.caches) {
            if (!(iCache instanceof LabelValueProviderRefsCacheBuilder)) continue;
            Set fileSet = iCache.getCacheMap().keySet();
            for (File file : fileSet) {
                Element element;
                Map cacheMap = (Map)iCache.getCacheMap().get(file);
                Object URIFRAGMENT_ELEMENT_Map = cacheMap.get(CacheEnum.URIFRAGMENT_ELEMENT.name());
                Object UUID_ELEMENT_Map = cacheMap.get(CacheEnum.UUID_ELEMENT.name());
                if (!(iURIFragment ? (element = (Element)((Map)URIFRAGMENT_ELEMENT_Map).get(labelReference)) != null : (element = (Element)((Map)UUID_ELEMENT_Map).get(labelReference)) != null)) continue;
                return element;
            }
        }
        return null;
    }

    private String createModeLabel(Element labelElement, File file) {
        String labelName = labelElement.getAttributeValue("name");
        Element modeLabel = this.getModeLabel(file, labelName);
        if (modeLabel == null) {
            Parent parent = labelElement.getParent();
            Element element = new Element("modeLabels");
            element.setAttribute("name", labelElement.getAttributeValue("name"));
            String uuid = EcoreUtil.generateUUID();
            element.setAttribute("id", uuid, this.helper.getGenericNS("xmi"));
            parent.addContent((Content)element);
            return uuid;
        }
        return modeLabel.getAttributeValue("id", this.helper.getGenericNS("xmi"));
    }
}

