/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.app4mc.amalthea._import.atdb.model.Isr;
import org.eclipse.app4mc.amalthea._import.atdb.model.Model;
import org.eclipse.app4mc.amalthea._import.atdb.model.Runnable;
import org.eclipse.app4mc.amalthea._import.atdb.model.Signal;
import org.eclipse.app4mc.amalthea._import.atdb.model.Stimulus;
import org.eclipse.app4mc.amalthea._import.atdb.model.Task;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CallGraph;
import org.eclipse.app4mc.amalthea.model.CallSequence;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.SingleStimulus;
import org.eclipse.app4mc.amalthea.model.StimuliModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class AmaltheaExporter {
    private URI uri = null;
    private AmaltheaFactory factory = null;
    private final Map<String, org.eclipse.app4mc.amalthea.model.Stimulus> stimuli = new HashMap<String, org.eclipse.app4mc.amalthea.model.Stimulus>();
    private final Map<String, org.eclipse.app4mc.amalthea.model.Runnable> runnables = new HashMap<String, org.eclipse.app4mc.amalthea.model.Runnable>();

    public AmaltheaExporter(URI uri) {
        this.uri = uri;
        AmaltheaPackage.eINSTANCE.eClass();
        this.factory = AmaltheaFactory.eINSTANCE;
    }

    public void serialise(IProgressMonitor progressMonitor, Model model) {
        Amalthea documentRoot = this.transform(model);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(this.uri);
        resource.getContents().add((Object)documentRoot);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        options.put("KEEP_DEFAULT_CONTENT", Boolean.TRUE);
        options.put("SCHEMA_LOCATION", Boolean.TRUE);
        options.put("http://www.w3.org/2001/XMLSchema", "am");
        try {
            resource.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        resource.unload();
    }

    private Amalthea transform(Model model) {
        Amalthea amalthea = this.factory.createAmalthea();
        StimuliModel stimuliModel = this.createStimuliModel(model);
        amalthea.setStimuliModel(stimuliModel);
        SWModel swModel = this.createSwModel(model);
        amalthea.setSwModel(swModel);
        return amalthea;
    }

    private StimuliModel createStimuliModel(Model model) {
        StimuliModel stimuliModel = this.factory.createStimuliModel();
        EList stimuli = stimuliModel.getStimuli();
        this.transformStimuli((EList<org.eclipse.app4mc.amalthea.model.Stimulus>)stimuli, model);
        return stimuliModel;
    }

    private void transformStimuli(EList<org.eclipse.app4mc.amalthea.model.Stimulus> stimuli, Model model) {
        for (Stimulus myStimulus : model.getStimuli()) {
            SingleStimulus aStimulus = this.factory.createSingleStimulus();
            aStimulus.setName(myStimulus.getName());
            Time time = this.factory.createTime();
            time.setValue(BigInteger.valueOf(myStimulus.getMoment()));
            time.setUnit(TimeUnit.get((int)myStimulus.getTimeBase()));
            aStimulus.setOccurrence(time);
            stimuli.add((Object)aStimulus);
            this.stimuli.put(aStimulus.getName(), (org.eclipse.app4mc.amalthea.model.Stimulus)aStimulus);
        }
    }

    private SWModel createSwModel(Model model) {
        SWModel swModel = this.factory.createSWModel();
        EList runnables = swModel.getRunnables();
        this.transformRunnables((EList<org.eclipse.app4mc.amalthea.model.Runnable>)runnables, model);
        EList tasks = swModel.getTasks();
        this.transformTasks((EList<org.eclipse.app4mc.amalthea.model.Task>)tasks, model);
        EList isrs = swModel.getIsrs();
        this.transformIsrs((EList<ISR>)isrs, model);
        EList labels = swModel.getLabels();
        this.transformLabels((EList<Label>)labels, model);
        return swModel;
    }

    private void transformTasks(EList<org.eclipse.app4mc.amalthea.model.Task> tasks, Model model) {
        for (Task myTask : model.getTasks()) {
            org.eclipse.app4mc.amalthea.model.Task aTask = this.factory.createTask();
            aTask.setName(myTask.getName());
            EList stimuli = aTask.getStimuli();
            for (String stimulus : myTask.getStimuli()) {
                stimuli.add((Object)this.stimuli.get(stimulus));
            }
            CallGraph callGraph = this.factory.createCallGraph();
            EList graphEntry = callGraph.getGraphEntries();
            CallSequence callSequence = this.factory.createCallSequence();
            EList callItemList = callSequence.getCalls();
            for (String name : myTask.getRunnableCalls()) {
                TaskRunnableCall runnableCall = this.factory.createTaskRunnableCall();
                runnableCall.setRunnable(this.runnables.get(name));
                callItemList.add((Object)runnableCall);
            }
            graphEntry.add((Object)callSequence);
            aTask.setCallGraph(callGraph);
            tasks.add((Object)aTask);
        }
    }

    private void transformIsrs(EList<ISR> isrs, Model model) {
        for (Isr myIsr : model.getIsrs()) {
            ISR aIsr = this.factory.createISR();
            aIsr.setName(myIsr.getName());
            isrs.add((Object)aIsr);
        }
    }

    private void transformRunnables(EList<org.eclipse.app4mc.amalthea.model.Runnable> runnables, Model model) {
        for (Runnable myRunnable : model.getRunnables()) {
            org.eclipse.app4mc.amalthea.model.Runnable aRunnable = this.factory.createRunnable();
            aRunnable.setName(myRunnable.getName());
            runnables.add((Object)aRunnable);
            this.runnables.put(aRunnable.getName(), aRunnable);
        }
    }

    private void transformLabels(EList<Label> labels, Model model) {
        for (Signal mySignal : model.getSignals()) {
            Label aLabel = this.factory.createLabel();
            aLabel.setName(mySignal.getName());
            labels.add((Object)aLabel);
        }
    }
}

