/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.model.AccessPath;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.ComplexNode;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Deviation;
import org.eclipse.app4mc.amalthea.model.ECU;
import org.eclipse.app4mc.amalthea.model.HwAccessPath;
import org.eclipse.app4mc.amalthea.model.LatencyAccessPath;
import org.eclipse.app4mc.amalthea.model.LatencyAccessPathElement;
import org.eclipse.app4mc.amalthea.model.LatencyConstant;
import org.eclipse.app4mc.amalthea.model.LatencyDeviation;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.Microcontroller;
import org.eclipse.app4mc.amalthea.model.util.RuntimeUtil;
import org.eclipse.emf.common.util.EList;

public class HardwareUtil {
    public static List<Core> getCoresInSystem(Amalthea model) {
        ArrayList<Core> results = new ArrayList<Core>();
        if (model.getHwModel() != null && model.getHwModel().getSystem() != null && model.getHwModel().getSystem().getEcus() != null) {
            for (ECU ecu : model.getHwModel().getSystem().getEcus()) {
                if (ecu.getMicrocontrollers() == null) continue;
                for (Microcontroller mc : ecu.getMicrocontrollers()) {
                    results.addAll((Collection<Core>)mc.getCores());
                }
            }
        }
        return results;
    }

    public static List<Core> getAllCoresForCoreType(Amalthea model, CoreType coreType) {
        ArrayList<Core> coresWithGivenCoreType = new ArrayList<Core>();
        List<Core> coresInSystem = HardwareUtil.getCoresInSystem(model);
        if (coreType == null) {
            return new ArrayList<Core>();
        }
        for (Core core : coresInSystem) {
            if (!coreType.equals(core.getCoreType())) continue;
            coresWithGivenCoreType.add(core);
        }
        return coresWithGivenCoreType;
    }

    public static List<Memory> getMemoriesInSystem(Amalthea model) {
        EList<ECU> ecuList = model.getHwModel().getSystem().getEcus();
        ArrayList<Memory> memoryList = new ArrayList<Memory>();
        for (ECU ecu : ecuList) {
            EList<Microcontroller> ucList = ecu.getMicrocontrollers();
            for (Microcontroller microcontroller : ucList) {
                memoryList.addAll((Collection<Memory>)microcontroller.getMemories());
                for (Core core : microcontroller.getCores()) {
                    memoryList.addAll((Collection<Memory>)core.getMemories());
                }
            }
        }
        return memoryList;
    }

    public static List<AccessPath> getAccessPathsOfHardwareNode(ComplexNode hardwareNode, Amalthea model) {
        ArrayList<AccessPath> result = new ArrayList<AccessPath>();
        for (AccessPath accessPath : model.getHwModel().getAccessPaths()) {
            if ((accessPath.getSource() == null || !accessPath.getSource().equals(hardwareNode)) && (accessPath.getTarget() == null || !accessPath.getTarget().equals(hardwareNode))) continue;
            result.add(accessPath);
        }
        return result;
    }

    public static long getLatency(ComplexNode source, ComplexNode target, Amalthea model) {
        Map<ComplexNode, List<Long>> accessLatenciesForHardwareNode = HardwareUtil.getAccessLatenciesForHardwareNode(source, RuntimeUtil.TimeType.WCET, model);
        List<Long> latencies = accessLatenciesForHardwareNode.get(target);
        if (latencies == null) {
            return 0L;
        }
        long latency = Long.MAX_VALUE;
        for (Long l : latencies) {
            if (l >= latency) continue;
            latency = l;
        }
        return latency;
    }

    public static List<LatencyAccessPath> getLatencyAccessPathsOfHardwareNode(ComplexNode hardwareNode, Amalthea model) {
        ArrayList<LatencyAccessPath> result = new ArrayList<LatencyAccessPath>();
        for (AccessPath accessPath : HardwareUtil.getAccessPathsOfHardwareNode(hardwareNode, model)) {
            if (!(accessPath instanceof LatencyAccessPath)) continue;
            LatencyAccessPath latencyPath = (LatencyAccessPath)accessPath;
            result.add(latencyPath);
        }
        return result;
    }

    public static Map<Core, HashMap<Memory, Long>> getAccessLatencies(Amalthea model) {
        HashMap<Core, HashMap<Memory, Long>> coreMemoryLatency = new HashMap<Core, HashMap<Memory, Long>>();
        HashMap<Memory, Long> memoryLatency = null;
        List<Core> coreList = HardwareUtil.getCoresInSystem(model);
        List<Memory> memoryList = HardwareUtil.getMemoriesInSystem(model);
        for (Core core : coreList) {
            memoryLatency = new HashMap<Memory, Long>();
            for (Memory memory : memoryList) {
                long accessLatency = HardwareUtil.getLatency(core, memory, model);
                if (accessLatency == 0L) continue;
                memoryLatency.put(memory, accessLatency);
            }
            coreMemoryLatency.put(core, memoryLatency);
        }
        return coreMemoryLatency;
    }

    public static List<HwAccessPath> getHardwareAccessPathsOfHardwareNode(ComplexNode hardwareNode, Amalthea model) {
        ArrayList<HwAccessPath> result = new ArrayList<HwAccessPath>();
        for (AccessPath accessPath : HardwareUtil.getAccessPathsOfHardwareNode(hardwareNode, model)) {
            if (!(accessPath instanceof HwAccessPath)) continue;
            HwAccessPath latencyPath = (HwAccessPath)accessPath;
            result.add(latencyPath);
        }
        return result;
    }

    public static Map<ComplexNode, List<Long>> getAccessLatenciesForHardwareNode(ComplexNode hardwareNode, RuntimeUtil.TimeType timeType, Amalthea model) {
        HashMap<ComplexNode, List<Long>> result = new HashMap<ComplexNode, List<Long>>();
        List<LatencyAccessPath> latencyAccessPathsOfCore = HardwareUtil.getLatencyAccessPathsOfHardwareNode(hardwareNode, model);
        for (LatencyAccessPath latencyPath : latencyAccessPathsOfCore) {
            ComplexNode target = null;
            if (latencyPath.getSource().equals(hardwareNode)) {
                if (latencyPath.getTarget() != null) {
                    target = latencyPath.getTarget();
                }
            } else if (latencyPath.getSource() != null) {
                target = latencyPath.getSource();
            }
            ArrayList<Long> latList = new ArrayList<Long>();
            for (LatencyAccessPathElement latency : latencyPath.getLatencies()) {
                if (latency instanceof LatencyConstant) {
                    latList.add(((LatencyConstant)latency).getValue());
                    continue;
                }
                if (!(latency instanceof LatencyDeviation)) continue;
                Deviation<LongObject> deviation = ((LatencyDeviation)latency).getDeviation();
                if (timeType == null) {
                    latList.add(RuntimeUtil.getMean(deviation.getDistribution(), deviation.getLowerBound().getValue(), deviation.getUpperBound().getValue()));
                    continue;
                }
                switch (timeType) {
                    case ACET: {
                        latList.add(RuntimeUtil.getMean(deviation.getDistribution(), deviation.getLowerBound().getValue(), deviation.getUpperBound().getValue()));
                        break;
                    }
                    case BCET: {
                        latList.add(deviation.getLowerBound().getValue());
                        break;
                    }
                    case WCET: {
                        latList.add(deviation.getUpperBound().getValue());
                        break;
                    }
                }
            }
            if (result.get(target) != null) {
                result.get(target).addAll(latList);
                continue;
            }
            result.put(target, latList);
        }
        return result;
    }

    public static Map<ComplexNode, List<Object>> getAccessLatencyDeviationsForHardwareNode(ComplexNode hardwareNode, Amalthea model) {
        HashMap<ComplexNode, List<Object>> result = new HashMap<ComplexNode, List<Object>>();
        List<LatencyAccessPath> latencyAccessPathsOfCore = HardwareUtil.getLatencyAccessPathsOfHardwareNode(hardwareNode, model);
        for (LatencyAccessPath latencyPath : latencyAccessPathsOfCore) {
            ComplexNode target = null;
            if (latencyPath.getSource().equals(hardwareNode)) {
                if (latencyPath.getTarget() != null) {
                    target = latencyPath.getTarget();
                }
            } else if (latencyPath.getSource() != null) {
                target = latencyPath.getSource();
            }
            for (LatencyAccessPathElement latency : latencyPath.getLatencies()) {
                if (!(latency instanceof LatencyDeviation)) continue;
                if (result.get(target) != null) {
                    result.get(target).add(latency);
                    continue;
                }
                ArrayList<LatencyAccessPathElement> tmp = new ArrayList<LatencyAccessPathElement>();
                tmp.add(latency);
                result.put(target, tmp);
            }
        }
        return result;
    }

    public static long getFrequencyOfCore(Core core) {
        long preScaler = 1L;
        switch (core.getPrescaler().getQuartz().getFrequency().getUnit()) {
            case GHZ: {
                preScaler = 1000000000L;
                break;
            }
            case MHZ: {
                preScaler = 1000000L;
                break;
            }
            case KHZ: {
                preScaler = 1000L;
                break;
            }
            case HZ: {
                preScaler = 1L;
                break;
            }
            default: {
                preScaler = 1L;
            }
        }
        long frequency = (long)(core.getPrescaler().getQuartz().getFrequency().getValue() * (double)preScaler * core.getPrescaler().getClockRatio());
        return frequency;
    }
}

