/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractTime;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.Time;
import org.eclipse.app4mc.amalthea.model.TimeUnit;

public class TimeUtil {
    public static Long compareTime(AbstractTime t1, AbstractTime t2) {
        BigInteger f4;
        BigInteger f3;
        int f2;
        List<TimeUnit> unitList = TimeUtil.getTimeUnitList();
        if (t1 == null && t2 == null) {
            return 0L;
        }
        if (t1 == null && t2 != null) {
            return -1L;
        }
        if (t1 != null && t2 == null) {
            return 1L;
        }
        int f1 = unitList.indexOf((Object)t1.getUnit());
        if (f1 > (f2 = unitList.indexOf((Object)t2.getUnit()))) {
            f3 = BigInteger.valueOf((long)Math.pow(1000.0, f1 - f2));
            f4 = BigInteger.valueOf(1L);
        } else {
            f3 = BigInteger.valueOf(1L);
            f4 = BigInteger.valueOf((long)Math.pow(1000.0, f2 - f1));
        }
        f4 = f4.multiply(t1.getValue());
        f3 = f3.multiply(t2.getValue());
        return f4.subtract(f3).longValue();
    }

    public static Time addTimes(AbstractTime time1, AbstractTime time2) {
        TimeUtil.fixTimeUnit(time1);
        TimeUtil.fixTimeUnit(time2);
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int unit1index = units.indexOf((Object)time1.getUnit());
        int unit2index = units.indexOf((Object)time2.getUnit());
        int targetIndex = Math.max(unit1index, unit2index);
        AbstractTime t1 = TimeUtil.convertToTimeUnit(time1, units.get(targetIndex));
        AbstractTime t2 = TimeUtil.convertToTimeUnit(time2, units.get(targetIndex));
        Time t = TimeUtil.adjustTimeUnit(t1.getValue().add(t2.getValue()), units.get(targetIndex));
        return t;
    }

    public static AbstractTime subtractTimes(AbstractTime time1, AbstractTime time2) {
        TimeUtil.fixTimeUnit(time1);
        TimeUtil.fixTimeUnit(time2);
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int unit1index = units.indexOf((Object)time1.getUnit());
        int unit2index = units.indexOf((Object)time2.getUnit());
        if (unit1index >= unit2index) {
            AbstractTime t1 = TimeUtil.convertToTimeUnit(time1, time1.getUnit());
            AbstractTime t2 = TimeUtil.convertToTimeUnit(time2, time1.getUnit());
            return TimeUtil.adjustTimeUnit(t1.getValue().subtract(t2.getValue()), time1.getUnit());
        }
        AbstractTime t1 = TimeUtil.convertToTimeUnit(time1, time2.getUnit());
        AbstractTime t2 = TimeUtil.convertToTimeUnit(time2, time2.getUnit());
        return TimeUtil.adjustTimeUnit(t1.getValue().subtract(t2.getValue()), time2.getUnit());
    }

    public static Time multiplyTime(AbstractTime time, double value) {
        if (value <= 0.0) {
            return null;
        }
        BigDecimal bdTime = new BigDecimal(time.getValue());
        BigDecimal bdValue = new BigDecimal(value);
        bdTime = bdTime.multiply(bdValue, MathContext.DECIMAL128);
        Time newTime = TimeUtil.adjustTimeUnit(bdTime.toBigInteger(), time.getUnit());
        return newTime;
    }

    public static double divideTimes(AbstractTime time1, AbstractTime time2) {
        int unit2index;
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int unit1index = units.indexOf((Object)time1.getUnit());
        if (unit1index >= (unit2index = units.indexOf((Object)time2.getUnit()))) {
            BigDecimal bd1 = new BigDecimal(time1.getValue());
            BigDecimal bd2 = new BigDecimal(time2.getValue());
            bd2 = bd2.scaleByPowerOfTen((unit1index - unit2index) * 3);
            return bd1.divide(bd2, MathContext.DECIMAL128).doubleValue();
        }
        BigDecimal bd1 = new BigDecimal(time1.getValue());
        BigDecimal bd2 = new BigDecimal(time2.getValue());
        bd1 = bd1.scaleByPowerOfTen((unit2index - unit1index) * 3);
        return bd1.divide(bd2, MathContext.DECIMAL128).doubleValue();
    }

    public static String timeToString(AbstractTime time) {
        if (time == null) {
            return "null";
        }
        return time.getValue() + time.getUnit().getName();
    }

    public static List<TimeUnit> getTimeUnitList() {
        return TimeUnit.VALUES;
    }

    private static void fixTimeUnit(AbstractTime time) {
        if (time != null && time.getValue() != null && time.getValue().intValue() == 0 && time.getUnit().equals((Object)TimeUnit._UNDEFINED_)) {
            time.setUnit(TimeUnit.MS);
        }
    }

    public static Time adjustTimeUnit(double runtime, TimeUnit timeUnit) {
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int timeUnitIndex = units.indexOf((Object)timeUnit);
        while (runtime - Math.floor(runtime) > 0.0 && timeUnitIndex < units.size() - 1) {
            runtime *= 1000.0;
            ++timeUnitIndex;
        }
        return TimeUtil.adjustTimeUnit(BigInteger.valueOf((long)runtime), units.get(timeUnitIndex));
    }

    public static Time adjustTimeUnit(BigInteger runtime, TimeUnit timeUnit) {
        BigInteger maxInt = BigInteger.valueOf(Integer.MAX_VALUE);
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int startTimeUnitIndex = units.indexOf((Object)TimeUnit.S);
        int timeUnitIndex = units.indexOf((Object)timeUnit);
        while ((runtime.compareTo(maxInt) > 0 || runtime.mod(BigInteger.valueOf(1000L)).compareTo(BigInteger.valueOf(0L)) == 0) && runtime.compareTo(BigInteger.valueOf(1000L)) >= 0 && timeUnitIndex > startTimeUnitIndex) {
            runtime = runtime.divide(BigInteger.valueOf(1000L));
            --timeUnitIndex;
        }
        Time time = AmaltheaFactory.eINSTANCE.createTime();
        time.setValue(runtime);
        time.setUnit(units.get(timeUnitIndex));
        return time;
    }

    public static AbstractTime convertToTimeUnit(AbstractTime time, TimeUnit unit) {
        if (time.getUnit() == unit) {
            return time;
        }
        Time newTime = AmaltheaFactory.eINSTANCE.createTime();
        List<TimeUnit> units = TimeUtil.getTimeUnitList();
        int power = units.indexOf((Object)unit) - units.indexOf((Object)time.getUnit());
        double factor = Math.pow(1000.0, power);
        if (factor >= 1.0) {
            newTime.setValue(time.getValue().multiply(new BigInteger("" + (long)factor)));
        } else {
            factor = 1.0 / factor;
            newTime.setValue(time.getValue().divide(new BigInteger("" + (long)factor)));
        }
        newTime.setUnit(unit);
        return newTime;
    }
}

