/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.wizards;

import java.util.ArrayList;
import org.eclipse.app4mc.multicore.dialogs.wizards.AbstractWizardPage;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AbstractWizard
extends Wizard
implements IWizard {
    private boolean debug_log = false;

    public AbstractWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public int getPageCount() {
        int count = this.getPages().length;
        this.log("getPageCount returned: " + count);
        return count;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage == null) {
            this.log("getNextPage returned: null");
            return null;
        }
        if (!(nextPage instanceof AbstractWizardPage)) {
            this.log("getNextPage returned: " + nextPage.getTitle());
            return nextPage;
        }
        AbstractWizardPage absPage = (AbstractWizardPage)nextPage;
        if (absPage.isEnabled()) {
            this.log("getNextPage returned: " + nextPage.getTitle());
            return nextPage;
        }
        return this.getNextPage(nextPage);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] pages = this.getPages();
        int currentPageIndex = 0;
        int prevPageIndex = 0;
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage currPage = iWizardPageArray[n2];
            if (currPage.equals(page)) break;
            ++currentPageIndex;
            ++n2;
        }
        prevPageIndex = currentPageIndex - 1;
        if (prevPageIndex >= 0) {
            this.log("getPreviousPage returned: " + pages[prevPageIndex]);
            return pages[prevPageIndex];
        }
        this.log("getPreviousPage returned: null");
        return null;
    }

    public IWizardPage[] getPages() {
        ArrayList<IWizardPage> enabledPages = new ArrayList<IWizardPage>();
        this.log("getPages returned: ");
        IWizardPage[] iWizardPageArray = super.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage currPage = iWizardPageArray[n2];
            if (((AbstractWizardPage)currPage).isEnabled()) {
                enabledPages.add(currPage);
                this.log("--> [" + currPage.getTitle() + "]");
            }
            ++n2;
        }
        return enabledPages.toArray(new IWizardPage[enabledPages.size()]);
    }

    public boolean needsPreviousAndNextButtons() {
        Boolean needs = true;
        this.log("needsPreviousAndNextButtons returned: " + needs.toString());
        return needs;
    }

    public boolean performFinish() {
        this.log("Calling unimplemented performFinish method");
        return false;
    }

    public void setLoggingEnabled(boolean enabled) {
        this.debug_log = enabled;
    }

    private void log(String message) {
        if (!this.debug_log) {
            return;
        }
        UniversalHandler.getInstance().log(message);
    }

    public boolean store() {
        boolean success = true;
        IWizardPage[] iWizardPageArray = super.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage currPage = iWizardPageArray[n2];
            if (currPage instanceof AbstractWizardPage) {
                this.log("store stored: " + currPage.getTitle());
                success &= ((AbstractWizardPage)currPage).store();
            }
            ++n2;
        }
        return success;
    }
}

