/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.dialogs.wizards;

import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.workflow.core.Context;
import org.eclipse.app4mc.amalthea.workflow.core.DefaultContext;
import org.eclipse.app4mc.multicore.dialogs.DialogsPlugin;
import org.eclipse.app4mc.multicore.dialogs.wizards.AbstractWizard;
import org.eclipse.app4mc.multicore.dialogs.wizards.page.FlowPage;
import org.eclipse.app4mc.multicore.dialogs.wizards.page.MappingPage;
import org.eclipse.app4mc.multicore.dialogs.wizards.page.PartitioningPage;
import org.eclipse.app4mc.multicore.dialogs.wizards.page.SummaryPage;
import org.eclipse.app4mc.multicore.dialogs.wizards.page.TaskCreationPage;
import org.eclipse.app4mc.multicore.openmapping.model.description.OMModelDescriptionBuilder;
import org.eclipse.app4mc.multicore.openmapping.workflow.CreateTasks;
import org.eclipse.app4mc.multicore.openmapping.workflow.GenerateMapping;
import org.eclipse.app4mc.multicore.partitioning.specs.PartitioningModelDescriptionBuilder;
import org.eclipse.app4mc.multicore.partitioning.workflow.GeneratePartitioning;
import org.eclipse.app4mc.multicore.partitioning.workflow.PrePartitioningWrkflw;
import org.eclipse.app4mc.multicore.sharelibs.DebugUtil;
import org.eclipse.app4mc.multicore.sharelibs.OutputPathParser;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.ModelDescription;
import org.eclipse.app4mc.multicore.sharelibs.modelchecker.logger.ModelSpecLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class MulticoreWizard
extends AbstractWizard
implements INewWizard {
    private final IPreferenceStore store = DialogsPlugin.getDefaultPreferenceStore();
    private IFile selectedFile;
    protected static final String AMALTHEA_SLOT = "amalthea";

    public MulticoreWizard() {
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)new FlowPage(this.store));
        this.addPage((IWizardPage)new PartitioningPage(this.store));
        this.addPage((IWizardPage)new TaskCreationPage(this.store));
        this.addPage((IWizardPage)new MappingPage(this.store));
        this.addPage((IWizardPage)new SummaryPage(this.store));
        this.setForcePreviousAndNextButtons(true);
    }

    @Override
    public boolean performFinish() {
        ModelSpecLogger logger;
        boolean success;
        DefaultContext ctx;
        block19: {
            ctx = new DefaultContext();
            success = true;
            logger = ModelSpecLogger.of();
            UniversalHandler.getInstance().clearModelCheckerView();
            success &= this.store();
            UniversalHandler.getInstance().readModels(URI.createPlatformResourceURI((String)this.selectedFile.getFullPath().toString(), (boolean)true), true);
            ctx.set(AMALTHEA_SLOT, (Object)UniversalHandler.getInstance().getCentralModel());
            if (!this.store.getBoolean("org.eclipse.app4mc.multicore.dialogs.partitioning_check")) break block19;
            ModelDescription inputModelChecker = PartitioningModelDescriptionBuilder.ofInput((Amalthea)UniversalHandler.getInstance().getCentralModel()).setLogger(logger);
            boolean modelOk = inputModelChecker.checkModel(this.selectedFile.getFullPath().toString(), UniversalHandler.getInstance().getCentralModel());
            if (!modelOk) {
                this.showModelCheckerLog(logger);
                return false;
            }
            PrePartitioningWrkflw prePartWF = new PrePartitioningWrkflw();
            GeneratePartitioning PartWF = new GeneratePartitioning();
            prePartWF.setAa(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolActivation"));
            prePartWF.setEffEdge(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolEffEdge"));
            prePartWF.setGgp(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolGGP"));
            prePartWF.setMinimEdge(this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolMinEdges"));
            prePartWF.run((Context)ctx);
            ctx.set(AMALTHEA_SLOT, ctx.get(prePartWF.getResultSlot()));
            DebugUtil.print((String)"Finished prepartitioning");
            PartWF.setModelLoc(this.selectedFile.getFullPath().toString());
            PartWF.setNumberOfPartitions(new Integer(this.store.getInt("org.eclipse.app4mc.multicore.partitioning.intThreads")).toString());
            switch (this.store.getString("org.eclipse.app4mc.multicore.partitioning.partAlgorithm")) {
                case "essp": {
                    PartWF.setPartitioningAlg("essp");
                    break;
                }
                case "cpp": {
                    PartWF.setPartitioningAlg("cpp");
                    break;
                }
            }
            PartWF.run((Context)ctx);
            DebugUtil.print((String)"Finished partitioning");
            ctx.set(AMALTHEA_SLOT, ctx.get(PartWF.getResultSlot()));
        }
        if (this.store.getBoolean("org.eclipse.app4mc.multicore.dialogs.create_tasks_check")) {
            CreateTasks createTask = new CreateTasks();
            ModelDescription inputModelChecker = OMModelDescriptionBuilder.ofTaskCreationInput(null).setLogger(logger);
            boolean modelOk = inputModelChecker.checkModel(this.selectedFile.getFullPath().toString(), (Amalthea)ctx.get(AMALTHEA_SLOT));
            if (!modelOk) {
                this.showModelCheckerLog(logger);
                return false;
            }
            createTask.setEnableLog(this.store.getBoolean("org.eclipse.app4mc.multicore.openmapping.logToConsole"));
            createTask.run((Context)ctx);
            ctx.set(AMALTHEA_SLOT, ctx.get(createTask.getResultSlot()));
            ModelDescription outputModelChecker = OMModelDescriptionBuilder.ofTaskCreationOutput((Amalthea)((Amalthea)ctx.get(AMALTHEA_SLOT))).setLogger(logger);
            modelOk = outputModelChecker.checkModel("<Internal> Task Creation Output Model", (Amalthea)ctx.get(AMALTHEA_SLOT));
            if (!modelOk) {
                this.showModelCheckerLog(logger);
                return false;
            }
        }
        if (this.store.getBoolean("org.eclipse.app4mc.multicore.dialogs.mapping_check")) {
            Amalthea model = (Amalthea)ctx.get(AMALTHEA_SLOT);
            GenerateMapping mapping = new GenerateMapping();
            String hwModelPath = this.store.getString("org.eclipse.app4mc.multicore.dialogs.hw_model_location");
            URI uriHwModel = URI.createFileURI((String)hwModelPath);
            UniversalHandler.getInstance().readModels(uriHwModel, true);
            ModelDescription modelChecker = OMModelDescriptionBuilder.ofMappingSWInput(null).setLogger(logger);
            boolean modelOk = modelChecker.checkModel(this.selectedFile.getFullPath().toString(), (Amalthea)ctx.get(AMALTHEA_SLOT));
            if (!modelOk) {
                this.showModelCheckerLog(logger);
                return false;
            }
            modelChecker = OMModelDescriptionBuilder.ofMappingHWInput(null).setLogger(logger);
            modelOk = modelChecker.checkModel(hwModelPath, UniversalHandler.getInstance().getCentralModel());
            if (!modelOk) {
                this.showModelCheckerLog(logger);
                return false;
            }
            model.setHwModel(UniversalHandler.getInstance().getHwModel());
            ctx.set(AMALTHEA_SLOT, (Object)model);
            mapping.setStore(this.store);
            mapping.run((Context)ctx);
            ctx.set(AMALTHEA_SLOT, ctx.get(mapping.getResultSlot()));
        }
        OutputPathParser outputParser = new OutputPathParser("org.eclipse.app4mc.multicore.dialogs.output_path_radio", "org.eclipse.app4mc.multicore.dialogs.output_path", this.store);
        URI path = outputParser.parseOutputFileURI(this.selectedFile, "_wizard");
        UniversalHandler.getInstance().logCon("Writing model to: " + path.toString());
        try {
            UniversalHandler.getInstance().writeModel(path, (EObject)((Amalthea)ctx.get(AMALTHEA_SLOT)));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.showModelCheckerLog(logger);
        return success;
    }

    private void showModelCheckerLog(ModelSpecLogger logger) {
        logger.logToView();
        logger.openMessageBox();
    }

    public String getPartitioningAppend() {
        switch (this.store.getString("org.eclipse.app4mc.multicore.partitioning.partAlgorithm")) {
            case "essp": {
                return "_ESSP";
            }
            case "cpp": {
                return "_CPP";
            }
        }
        if (this.store.getBoolean("org.eclipse.app4mc.multicore.partitioning.boolTA")) {
            return "_TAInput";
        }
        return null;
    }

    public String getOutputFileName(String append) {
        return this.selectedFile.getName().toString().replace(".amxmi", String.valueOf(append) + "." + "amxmi");
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection.getFirstElement() instanceof IFile) {
            this.selectedFile = (IFile)selection.getFirstElement();
        }
        UniversalHandler.getInstance().readModels(URI.createFileURI((String)this.selectedFile.getLocation().toString()), true);
        if (UniversalHandler.getInstance().getHwModel() != null) {
            this.store.setValue("org.eclipse.app4mc.multicore.dialogs.hw_model_location", this.selectedFile.getLocation().toString());
        }
    }
}

