/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.FXGanttWidget;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.AbstractGanttViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ArrowTimeMarkerViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.DurationModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.FlashTimeMarkerViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.ProgressViewElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.gantt.elements.TimeMarkModelElement;
import org.eclipse.app4mc.multicore.execution.ui.widget.misc.FXUtil;
import org.eclipse.app4mc.multicore.execution.ui.widget.tracewidget.ITraceWidget;

public class TraceWidget
extends GridPane
implements ITraceWidget {
    private Map<String, Core> cores;
    private CheckBox cbScrollAllCharts;
    private Queue<QueueData> queue = new ConcurrentLinkedQueue<QueueData>();
    private int row = 0;
    private String axisLabel = "";

    public TraceWidget() {
        this.cores = new HashMap<String, Core>();
        this.setupPane();
        this.initDataPopulation();
    }

    private void setupPane() {
        ColumnConstraints column = new ColumnConstraints();
        column.setPercentWidth(10.0);
        this.getColumnConstraints().add((Object)column);
        column = new ColumnConstraints();
        column.setPercentWidth(90.0);
        this.getColumnConstraints().add((Object)column);
        this.setVgap(10.0);
        this.cbScrollAllCharts = new CheckBox("Scroll all charts");
        this.add((Node)this.cbScrollAllCharts, 0, this.row++);
        GridPane.setColumnSpan((Node)this.cbScrollAllCharts, (Integer)2);
        this.cbScrollAllCharts.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    for (Core c : TraceWidget.this.cores.values()) {
                        for (Core c2 : TraceWidget.this.cores.values()) {
                            if (c == c2) continue;
                            c.chart.getNumberAxis().lowerBoundProperty().bindBidirectional((Property)c2.chart.getNumberAxis().lowerBoundProperty());
                            c.chart.getNumberAxis().upperBoundProperty().bindBidirectional((Property)c2.chart.getNumberAxis().upperBoundProperty());
                        }
                    }
                } else {
                    for (Core c : TraceWidget.this.cores.values()) {
                        for (Core c2 : TraceWidget.this.cores.values()) {
                            if (c == c2) continue;
                            c.chart.getNumberAxis().lowerBoundProperty().unbindBidirectional((Property)c2.chart.getNumberAxis().lowerBoundProperty());
                            c.chart.getNumberAxis().upperBoundProperty().unbindBidirectional((Property)c2.chart.getNumberAxis().upperBoundProperty());
                        }
                    }
                }
            }
        });
    }

    @Override
    public void addTask(String core, final String task) {
        final Core c = this.cores.get(core);
        if (c == null) {
            return;
        }
        if (c.tasks.contains(task)) {
            return;
        }
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    c.chart.addCategorie(task);
                    c.tasks.add(task);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addTaskRunning(String core, String task, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, start, new ProgressViewElement("status-light-green", new DurationModelElement(start, stop - start, "running")));
        this.addToFXQueue(c.chart, "Core", start, new ProgressViewElement("status-green", new DurationModelElement(start, stop - start, "")));
    }

    @Override
    public void addTaskWaiting(String core, String task, String note, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, start, new ProgressViewElement("status-orange", new DurationModelElement(start, stop - start, "waiting\n" + note)));
    }

    @Override
    public void addTaskActivation(String core, String task, long time) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, time, new ArrowTimeMarkerViewElement("activate", new TimeMarkModelElement(time, "")));
    }

    @Override
    public void addTaskReady(String core, String task, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, start, new ProgressViewElement("status-yellow", new DurationModelElement(start, stop - start, "ready")));
    }

    @Override
    public void addTaskSuspended(String core, String task, long start, long stop) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, start, new ProgressViewElement("status-red", new DurationModelElement(start, stop - start, "suspended")));
    }

    @Override
    public void addTaskDeadlineMissed(String core, String task, long time) {
        if (!this.cores.containsKey(core)) {
            return;
        }
        if (!this.cores.get((Object)core).tasks.contains(task)) {
            return;
        }
        System.err.println("addTaskDeadlineMissed");
        Core c = this.cores.get(core);
        this.addToFXQueue(c.chart, task, time, new FlashTimeMarkerViewElement("", new TimeMarkModelElement(time, "deadline missed")));
    }

    public void setAxisLabels(String label) {
        this.axisLabel = label;
        for (Core c : this.cores.values()) {
            c.chart.getNumberAxis().setLabel(label);
        }
    }

    @Override
    public void addCore(String core) {
        final Core c = new Core();
        c.chart = new FXGanttWidget(30);
        c.chart.getStylesheets().add((Object)this.getClass().getResource("/icons/ganttchart.css").toExternalForm());
        c.chart.getNumberAxis().setLabel(this.axisLabel);
        c.tasks = new HashSet<String>();
        this.cores.put(core, c);
        c.chart.addCategorie("Core");
        c.nav = new VBox();
        StackPane sp = TraceWidget.createIcon(core, this.getClass().getResource("/icons/coreIcon.png").toExternalForm());
        c.nav.getChildren().add((Object)sp);
        Region nav = TraceWidget.createNav(c.chart.getNumberAxis().lowerBoundProperty(), c.chart.getNumberAxis().upperBoundProperty());
        c.nav.getChildren().add((Object)nav);
        VBox.setMargin((Node)c.nav, (Insets)new Insets(10.0));
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    TraceWidget.this.add((Node)c.nav, 0, TraceWidget.this.row);
                    TraceWidget.this.add((Node)c.chart, 1, TraceWidget.this.row);
                    TraceWidget traceWidget = TraceWidget.this;
                    traceWidget.row = traceWidget.row + 1;
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private static Region createNav(DoubleProperty lower, DoubleProperty upper) {
        VBox navPane = new VBox();
        Text labLb = new Text("Lower Bound");
        navPane.getChildren().add((Object)labLb);
        TextField txtLowerBond = new TextField();
        navPane.getChildren().add((Object)txtLowerBond);
        txtLowerBond.textProperty().bindBidirectional((Property)lower, (StringConverter)new NumberStringConverter());
        Text labUb = new Text("Upper Bound");
        navPane.getChildren().add((Object)labUb);
        TextField txtUpperBond = new TextField();
        navPane.getChildren().add((Object)txtUpperBond);
        txtUpperBond.textProperty().bindBidirectional((Property)upper, (StringConverter)new NumberStringConverter());
        return navPane;
    }

    private static StackPane createIcon(String txt, String url) {
        StackPane sp = new StackPane();
        ImageView ic = new ImageView(url);
        ic.setPreserveRatio(true);
        ic.setFitHeight(100.0);
        sp.getChildren().add((Object)ic);
        sp.getChildren().add((Object)new Text(txt));
        return sp;
    }

    @Override
    public void reset() {
        try {
            FXUtil.runLaterWait(new Runnable(){

                @Override
                public void run() {
                    TraceWidget.this.cores.values().forEach(x -> {
                        TraceWidget.this.getChildren().remove((Object)x.chart);
                        TraceWidget.this.getChildren().remove((Object)x.nav);
                    });
                    TraceWidget.this.cores.clear();
                    TraceWidget.this.row = TraceWidget.this.getChildren().size();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private void addToFXQueue(FXGanttWidget chart, String categorie, long start, AbstractGanttViewElement v) {
        QueueData d = new QueueData(chart, categorie, start, v);
        this.queue.add(d);
    }

    private void initDataPopulation() {
        new AnimationTimer(){

            public void handle(long now) {
                QueueData d = (QueueData)TraceWidget.this.queue.poll();
                if (d != null) {
                    d.chart.addEvent(d.categorie, d.start, d.v);
                }
            }
        }.start();
    }

    static class Core {
        FXGanttWidget chart;
        VBox nav;
        Set<String> tasks;

        Core() {
        }
    }

    static class QueueData {
        final String categorie;
        final long start;
        final AbstractGanttViewElement v;
        final FXGanttWidget chart;

        public QueueData(FXGanttWidget chart, String categorie, long start, AbstractGanttViewElement v) {
            this.chart = chart;
            this.categorie = categorie;
            this.start = start;
            this.v = v;
        }
    }
}

