/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms;

import java.util.ArrayList;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaMerger;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ga.constraints.GABasedConstraints;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ga.lb.GABasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.algorithms.helper.ListBuilder;
import org.eclipse.app4mc.multicore.openmapping.algorithms.heuristic.lb.LoadBalancingDFG;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization.EnergyMinimization;
import org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.lb.ILPBasedLoadBalancing;
import org.eclipse.app4mc.multicore.openmapping.model.AmaltheaModelBuilder;
import org.eclipse.app4mc.multicore.openmapping.model.OMAllocation;
import org.eclipse.app4mc.multicore.openmapping.model.OMCore;
import org.eclipse.app4mc.multicore.openmapping.model.OMMapping;
import org.eclipse.app4mc.multicore.openmapping.model.OMTask;
import org.eclipse.app4mc.multicore.openmapping.visualizer.OMVisualizer;
import org.eclipse.app4mc.multicore.sharelibs.ConsoleOutputHandler;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class AbstractMappingAlgorithm {
    public static final String LOAD_BALANCE_DFG = "0";
    public static final String LOAD_BALANCE_ILP = "1";
    public static final String ENERGY_MIN_ILP = "2";
    public static final String LOAD_BALANCE_GA = "3";
    public static final String LOAD_BALANCE_CONSTRAINTS_GA = "4";
    protected final ConsoleOutputHandler con = new ConsoleOutputHandler("OpenMapping Console");
    private Amalthea amaltheaSwModel;
    private Amalthea amaltheaHwModel;
    private Amalthea mergedModel;
    private Amalthea amaltheaOutputModel;
    private final Boolean hasConstraints = false;
    protected static IPreferenceStore store;

    public abstract void calculateMapping();

    public static AbstractMappingAlgorithm of(IPreferenceStore store) {
        AbstractMappingAlgorithm mappingAlgorithm;
        AbstractMappingAlgorithm.store = store;
        int mappingAlgorithmChoice = AbstractMappingAlgorithm.store.getInt("org.eclipse.app4mc.multicore.openmapping.mappingAlgorithm");
        switch (mappingAlgorithmChoice) {
            case 0: {
                mappingAlgorithm = new LoadBalancingDFG();
                break;
            }
            case 1: {
                mappingAlgorithm = new ILPBasedLoadBalancing();
                break;
            }
            case 2: {
                mappingAlgorithm = new EnergyMinimization();
                break;
            }
            case 3: {
                mappingAlgorithm = new GABasedLoadBalancing();
                break;
            }
            case 4: {
                mappingAlgorithm = new GABasedConstraints();
                break;
            }
            default: {
                return null;
            }
        }
        return mappingAlgorithm;
    }

    public boolean initModels() {
        if (this.mergedModel != null) {
            return true;
        }
        this.mergedModel = AmaltheaFactory.eINSTANCE.createAmalthea();
        if (this.amaltheaSwModel == null || this.amaltheaHwModel == null) {
            return false;
        }
        if (this.amaltheaSwModel.getCommonElements() != null && this.amaltheaHwModel.getCommonElements() != null) {
            ArrayList<Amalthea> models = new ArrayList<Amalthea>();
            Amalthea tmp1 = AmaltheaFactory.eINSTANCE.createAmalthea();
            tmp1.setCommonElements(this.amaltheaSwModel.getCommonElements());
            Amalthea tmp2 = AmaltheaFactory.eINSTANCE.createAmalthea();
            tmp2.setCommonElements(this.amaltheaHwModel.getCommonElements());
            models.add(tmp1);
            models.add(tmp2);
            AmaltheaMerger.addElements((Amalthea)this.mergedModel, models);
        } else if (this.amaltheaSwModel.getCommonElements() != null) {
            this.mergedModel.setCommonElements(this.amaltheaSwModel.getCommonElements());
        } else if (this.amaltheaHwModel.getCommonElements() != null) {
            this.mergedModel.setCommonElements(this.amaltheaHwModel.getCommonElements());
        }
        this.mergedModel.setComponentsModel(this.amaltheaSwModel.getComponentsModel());
        this.mergedModel.setConfigModel(this.amaltheaSwModel.getConfigModel());
        this.mergedModel.setConstraintsModel(this.amaltheaSwModel.getConstraintsModel());
        this.mergedModel.setEventModel(this.amaltheaSwModel.getEventModel());
        this.mergedModel.setHwModel(this.amaltheaHwModel.getHwModel());
        this.mergedModel.setPropertyConstraintsModel(this.amaltheaSwModel.getPropertyConstraintsModel());
        this.mergedModel.setStimuliModel(this.amaltheaSwModel.getStimuliModel());
        this.mergedModel.setSwModel(this.amaltheaSwModel.getSwModel());
        return true;
    }

    public Amalthea getAmaltheaSwModel() {
        return this.amaltheaSwModel;
    }

    public Amalthea getAmaltheaHwModel() {
        return this.amaltheaHwModel;
    }

    public Amalthea getMergedModel() {
        return this.mergedModel;
    }

    public Amalthea getAmaltheaOutputModel() {
        return this.amaltheaOutputModel;
    }

    public void setAmaltheaSwModel(Amalthea amaltheaSwModel) {
        this.amaltheaSwModel = amaltheaSwModel;
    }

    public void setAmaltheaHwModel(Amalthea amaltheaHwModel) {
        this.amaltheaHwModel = amaltheaHwModel;
    }

    public void setAmaltheaMergedModel(Amalthea modelCopy) {
        this.mergedModel = modelCopy;
    }

    public void setAmaltheaOutputModel(Amalthea amaltheaOutputModel) {
        this.amaltheaOutputModel = amaltheaOutputModel;
    }

    public Boolean hasConstraints() {
        return this.hasConstraints;
    }

    public boolean mapToFirstCore() {
        this.con.appendln(" Just one core found in Hardware model, skipping algorithm run...");
        ArrayList<OMTask> taskList = ListBuilder.getTaskList(this.getMergedModel().getSwModel());
        ArrayList<OMCore> coreList = ListBuilder.getCoreList(this.getMergedModel().getHwModel());
        OMMapping mapping = new OMMapping();
        for (OMTask task : taskList) {
            OMAllocation alloc = new OMAllocation(task, (OMCore)coreList.get(0));
            mapping.addAllocation(alloc);
        }
        this.updateModel(mapping);
        return true;
    }

    protected void updateModel(OMMapping mapping) {
        AmaltheaModelBuilder builder = new AmaltheaModelBuilder(mapping);
        this.getMergedModel().setOsModel(builder.getAmaltheaModel().getOsModel());
        this.getMergedModel().setMappingModel(builder.getAmaltheaModel().getMappingModel());
        this.setAmaltheaOutputModel(this.getMergedModel());
        try {
            OMVisualizer vis = new OMVisualizer(mapping);
            this.con.appendln("\n" + vis.getASCIIChart());
        }
        catch (ArithmeticException arithmeticException) {
            this.con.appendln("\n Visualization not available...");
        }
    }
}

