/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.openmapping.algorithms.ilp.energyminimization;

import java.math.BigDecimal;
import org.eclipse.app4mc.amalthea.model.AmaltheaServices;
import org.eclipse.app4mc.amalthea.model.Core;
import org.eclipse.app4mc.amalthea.model.CoreType;
import org.eclipse.app4mc.amalthea.model.Frequency;
import org.eclipse.app4mc.amalthea.model.Prescaler;
import org.eclipse.app4mc.amalthea.model.Quartz;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;

public class ExtendedCore
implements Comparable<ExtendedCore> {
    private Core core;
    private TaskScheduler sched;
    private double frequencyQuartz;
    private double ratioPrescaler;
    private double ticksPerSecond;
    private double ticksPerCycle;
    private double cyclesPerSecond;
    private double relativePerformance;
    private double load;

    public ExtendedCore(Core core, boolean debug) {
        UniversalHandler.getInstance().logCon("  Creating Core '" + core.getName() + "'");
        this.setCore(core);
        this.fetchFrequency();
    }

    public void fetchFrequency() {
        Prescaler ps = this.core.getPrescaler();
        if (ps == null) {
            UniversalHandler.getInstance().log("   Unexpected HWModel: Core contains no Prescaler.\nSkipping Core...", null);
            return;
        }
        if (ps.getClockRatio() <= 0.0) {
            UniversalHandler.getInstance().log("   Unexpected HWModel: clockRatio in Prescaler must be > 0.\nSkipping Core...", null);
            this.ratioPrescaler = 1.0;
        } else {
            this.ratioPrescaler = ps.getClockRatio();
        }
        Quartz q = ps.getQuartz();
        if (q == null) {
            UniversalHandler.getInstance().log("   Unexpected HWModel: Prescaler has an unset reference to Quartz.\nSkipping Core...", null);
            return;
        }
        CoreType ct = this.core.getCoreType();
        if (ct == null) {
            UniversalHandler.getInstance().log("   Unexpected HWModel: Core has an unset reference to CoreType.\nSkipping Core...", null);
            return;
        }
        this.ticksPerCycle = ct.getInstructionsPerCycle();
        BigDecimal frequency = AmaltheaServices.convertToHz((Frequency)q.getFrequency());
        this.frequencyQuartz = frequency.doubleValue();
        this.ticksPerSecond = this.frequencyQuartz * this.ratioPrescaler;
        this.cyclesPerSecond = this.ticksPerSecond * this.ticksPerCycle;
        System.out.println("DEBUG::" + this.frequencyQuartz);
        UniversalHandler.getInstance().logCon(this.toString());
    }

    @Override
    public int compareTo(ExtendedCore c) {
        if (this.cyclesPerSecond > c.cyclesPerSecond) {
            return -1;
        }
        if (this.cyclesPerSecond < c.cyclesPerSecond) {
            return 1;
        }
        return 0;
    }

    public Core getCore() {
        return this.core;
    }

    public void setCore(Core core) {
        this.core = core;
    }

    public double getCyclesPerSecond() {
        return this.cyclesPerSecond;
    }

    public double getTicksPerSecond() {
        return this.ticksPerSecond;
    }

    public double getRelativePerfomance() {
        return this.relativePerformance;
    }

    public void setRelativePerfomance(double relativePerformance) {
        this.relativePerformance = relativePerformance;
    }

    public double getLoad() {
        return this.load;
    }

    public void setLoad(double load) {
        this.load = load;
    }

    public TaskScheduler getScheduler() {
        return this.sched;
    }

    public void setScheduler(TaskScheduler sched) {
        this.sched = sched;
    }

    public String toString() {
        String out = "Technical Information for Core '" + this.getCore().getName() + "'\n";
        out = String.valueOf(out) + "Quartz Frequency: " + this.frequencyQuartz + "\n";
        out = String.valueOf(out) + "Quartz Prescaler: " + this.ratioPrescaler + "\n";
        out = String.valueOf(out) + "Ticks p. Second:  " + this.ticksPerSecond + "\n";
        out = String.valueOf(out) + "Ticks p. Cycle:   " + this.ticksPerCycle + "\n";
        out = String.valueOf(out) + "Cycles p. Second: " + this.cyclesPerSecond + "\n";
        return out;
    }
}

