/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.app4mc.amalthea.model.AccessPrecedenceSpec;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.ConstraintsModel;
import org.eclipse.app4mc.amalthea.model.Instructions;
import org.eclipse.app4mc.amalthea.model.InstructionsConstant;
import org.eclipse.app4mc.amalthea.model.InstructionsDeviation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.LabelAccess;
import org.eclipse.app4mc.amalthea.model.LabelAccessEnum;
import org.eclipse.app4mc.amalthea.model.LongObject;
import org.eclipse.app4mc.amalthea.model.PeriodicActivation;
import org.eclipse.app4mc.amalthea.model.ProcessPrototype;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.RunnableEntityGroup;
import org.eclipse.app4mc.amalthea.model.RunnableInstructions;
import org.eclipse.app4mc.amalthea.model.RunnableItem;
import org.eclipse.app4mc.amalthea.model.RunnableSequencingConstraint;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.model.TaskRunnableCall;
import org.eclipse.app4mc.multicore.partitioning.utils.PartLog;
import org.eclipse.app4mc.multicore.sharelibs.UniversalHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class Helper {
    List<Runnable> visited = new BasicEList();

    public long getInstructions(Runnable r) {
        long rt = 0L;
        for (RunnableItem ra : r.getRunnableItems()) {
            if (!(ra instanceof RunnableInstructions)) continue;
            RunnableInstructions ri = (RunnableInstructions)ra;
            rt += ri.getDefault() instanceof InstructionsConstant ? ((InstructionsConstant)ri.getDefault()).getValue() : (ri.getDefault() instanceof InstructionsDeviation ? (((LongObject)((InstructionsDeviation)ri.getDefault()).getDeviation().getLowerBound()).getValue() + ((LongObject)((InstructionsDeviation)ri.getDefault()).getDeviation().getUpperBound()).getValue()) / 2L : 0L);
        }
        if (rt == 0L) {
            PartLog.getInstance().log("No instructions constant / deviation found at Runnable " + r.getName() + ". Assuming 1.", null);
            InstructionsConstant ic = AmaltheaFactory.eINSTANCE.createInstructionsConstant();
            ic.setValue(1L);
            RunnableInstructions ri = AmaltheaFactory.eINSTANCE.createRunnableInstructions();
            ri.setDefault((Instructions)ic);
            r.getRunnableItems().add((Object)ri);
            rt = 1L;
        }
        return rt;
    }

    public ProcessPrototype getPPfromR(Runnable runnable, SWModel swm) {
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                if (!trc.getRunnable().equals(runnable)) continue;
                return pp;
            }
        }
        PartLog.getInstance().log("getPPFromR did not find PP for Runnable " + runnable.getName(), null);
        return null;
    }

    public long getPreceedingRunTimeCycle(ConstraintsModel cm, Runnable r) {
        if (r == null) {
            return Long.MAX_VALUE;
        }
        long rt = 0L;
        this.visited.add(r);
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            long temp;
            if (!((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)).equals(r) || this.visited.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)) || (temp = this.getPreceedingRunTimeCycle(cm, (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0))) <= rt) continue;
            rt = temp;
        }
        return rt + this.getInstructions(r);
    }

    public void checkTRCsVsAllRunnables(SWModel swm) {
        if (this.getAllTRCs(swm).size() < swm.getRunnables().size()) {
            ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
            pp.setName("AllRunnables");
            BasicEList alltrcs = new BasicEList();
            for (Runnable r : swm.getRunnables()) {
                TaskRunnableCall trc = AmaltheaFactory.eINSTANCE.createTaskRunnableCall();
                trc.setRunnable(r);
                alltrcs.add((Object)trc);
            }
            pp.getRunnableCalls().addAll((Collection)alltrcs);
            swm.getProcessPrototypes().add((Object)pp);
            PartLog.getInstance().log("Created AllRunnablesPP with " + alltrcs.size() + " TRCs");
        }
    }

    public boolean allRunnablesReferActivation(SWModel swm) {
        for (Runnable r : swm.getRunnables()) {
            if (r.getFirstActivation() != null) continue;
            return false;
        }
        return true;
    }

    public EList<TaskRunnableCall> getAllTRCs(SWModel swm) {
        BasicEList trcs = new BasicEList();
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            trcs.addAll((Collection)pp.getRunnableCalls());
        }
        return trcs;
    }

    public long getSucceedingRunTimeCycle(ConstraintsModel cm, Runnable r) {
        if (r == null) {
            return Long.MAX_VALUE;
        }
        long rt = 0L;
        this.visited.add(r);
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            long temp;
            if (!((Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0)).equals(r) || this.visited.contains(((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0)) || (temp = this.getSucceedingRunTimeCycle(cm, (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0))) <= rt) continue;
            rt = temp;
        }
        return rt + this.getInstructions(r);
    }

    public Label getCommonLabel(Runnable runnable, Runnable runnable2) {
        for (RunnableItem ri1 : runnable.getRunnableItems()) {
            if (!(ri1 instanceof LabelAccess)) continue;
            LabelAccess la1 = (LabelAccess)ri1;
            for (RunnableItem ri2 : runnable2.getRunnableItems()) {
                if (!(ri2 instanceof LabelAccess)) continue;
                LabelAccess la2 = (LabelAccess)ri2;
                if (!la1.getData().equals(la2.getData()) || (!la1.getAccess().equals((Object)LabelAccessEnum.READ) || !la2.getAccess().equals((Object)LabelAccessEnum.WRITE)) && (!la1.getAccess().equals((Object)LabelAccessEnum.WRITE) || !la2.getAccess().equals((Object)LabelAccessEnum.READ))) continue;
                return la1.getData();
            }
        }
        return null;
    }

    public static void writeModelFile(IFile file, URI path, ArrayList<EObject> models) {
        PartLog.getInstance().log("Writing " + path.toString() + "\n");
        UniversalHandler.getInstance().writeModel(path, models);
    }

    public static void writeModelFile(IFile file, URI path, Amalthea models) {
        PartLog.getInstance().log("Writing " + path.toString() + "\n");
        UniversalHandler.getInstance().writeModel(path, (EObject)models);
    }

    public EList<Runnable> getRunnables(ProcessPrototype pp) {
        BasicEList rl = new BasicEList();
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            rl.add((Object)trc.getRunnable());
        }
        return rl;
    }

    public Amalthea setAllModels(Amalthea amodels, UniversalHandler uh) {
        amodels.setCommonElements(uh.getCommonElements());
        amodels.setConstraintsModel(uh.getConstraintsModel());
        amodels.setHwModel(uh.getHwModel());
        amodels.setMappingModel(uh.getMappingModel());
        amodels.setOsModel(uh.getOsModel());
        amodels.setPropertyConstraintsModel(uh.getPropertyConstraintsModel());
        amodels.setStimuliModel(uh.getStimuliModel());
        amodels.setSwModel(uh.getSwModel());
        amodels.setEventModel(uh.getEvModel());
        amodels.setComponentsModel(uh.getComModel());
        amodels.setConfigModel(uh.getConfModel());
        return amodels;
    }

    public void assignAPs(Set<AccessPrecedenceSpec> aps) {
        for (AccessPrecedenceSpec ap : aps) {
            Runnable r = ap.getOrigin();
            EList trcs = r.getTaskRunnableCalls();
            for (TaskRunnableCall trc : trcs) {
                ProcessPrototype pp = AmaltheaFactory.eINSTANCE.createProcessPrototype();
                if (trc.eContainer() instanceof ProcessPrototype) {
                    pp = (ProcessPrototype)trc.eContainer();
                }
                if (pp.getName() == null || pp.getAccessPrecedenceSpec().contains((Object)ap)) continue;
                pp.getAccessPrecedenceSpec().add((Object)ap);
            }
        }
    }

    public ConstraintsModel updateRSCs(ConstraintsModel cm, SWModel swm) {
        for (RunnableSequencingConstraint rsc : cm.getRunnableSequencingConstraints()) {
            Runnable source = (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().get(0);
            Runnable target = (Runnable)((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().get(0);
            for (ProcessPrototype pp : swm.getProcessPrototypes()) {
                for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                    if (trc.getRunnable().equals(source)) {
                        rsc.getProcessScope().clear();
                        rsc.getProcessScope().add((Object)pp);
                        continue;
                    }
                    if (!trc.getRunnable().equals(target)) continue;
                    rsc.getProcessScope().clear();
                    rsc.getProcessScope().add((Object)pp);
                }
            }
        }
        return cm;
    }

    public SWModel updatePPsFirstLastActParams(SWModel swm) {
        for (ProcessPrototype pp : swm.getProcessPrototypes()) {
            if (pp.getRunnableCalls().size() > 0) {
                if (pp.getFirstRunnable() == null || pp.getFirstRunnable() != ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable()) {
                    pp.setFirstRunnable(((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable());
                }
                if (pp.getLastRunnable() == null || pp.getLastRunnable() != ((TaskRunnableCall)pp.getRunnableCalls().get(pp.getRunnableCalls().size() - 1)).getRunnable()) {
                    pp.setLastRunnable(((TaskRunnableCall)pp.getRunnableCalls().get(pp.getRunnableCalls().size() - 1)).getRunnable());
                }
            }
            if (pp.getActivation() == null && pp.getRunnableCalls().size() > 0 && ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getFirstActivation() != null) {
                pp.setActivation(((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getFirstActivation());
                continue;
            }
            if (pp.getRunnableCalls().size() <= 0 || ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getFirstActivation() != null) continue;
            PartLog.getInstance().log("Runnable " + ((TaskRunnableCall)pp.getRunnableCalls().get(0)).getRunnable().getName() + " has no activation, this might be a problem for the mapping process.");
        }
        return swm;
    }

    public String writePPs(EList<ProcessPrototype> processPrototypes) {
        StringBuffer sb = new StringBuffer();
        short i = 0;
        sb.append("******************************************************\n");
        sb.append(String.valueOf(String.format("%2S%22S%16S%6S", " #", "PP", "Instructionssum", "#TRCs")) + " TRCs\n");
        sb.append("******************************************************\n");
        for (ProcessPrototype pp : processPrototypes) {
            Object[] objectArray = new Object[4];
            short s = i;
            i = (short)(s + 1);
            objectArray[0] = s;
            objectArray[1] = pp.getName();
            objectArray[2] = this.getPPInstructions(pp);
            objectArray[3] = pp.getRunnableCalls().size();
            sb.append(String.valueOf(String.format("%2s%22.21s%16.15s%6s", objectArray)) + " ");
            for (TaskRunnableCall trc : pp.getRunnableCalls()) {
                sb.append(String.format("%30s", String.valueOf(trc.getRunnable().getName().substring(0, trc.getRunnable().getName().length() > 29 ? 29 : trc.getRunnable().getName().length())) + " "));
            }
            sb.append("\n");
        }
        sb.append("******************************************************");
        return sb.toString();
    }

    public long getPPInstructions(ProcessPrototype pp) {
        long instrSum = 0L;
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            instrSum += this.getInstructions(trc.getRunnable());
        }
        return instrSum;
    }

    public double getPPIntrSumActRel(ProcessPrototype pp) {
        long instrSum = 0L;
        for (TaskRunnableCall trc : pp.getRunnableCalls()) {
            instrSum += this.getInstructions(trc.getRunnable());
        }
        double mpis = 1.0;
        if (pp.getActivation() instanceof PeriodicActivation) {
            PeriodicActivation pact = (PeriodicActivation)pp.getActivation();
            mpis = this.getMeanActivation(pact) * this.getTimeUnit((Activation)pact);
        }
        instrSum = (long)((double)instrSum * mpis);
        return instrSum;
    }

    private double getMeanActivation(PeriodicActivation pact) {
        if (pact.getMax() != null && pact.getMin() != null && pact.getMax().getValue() != null && pact.getMin().getValue() != null && pact.getMax().getUnit() != null && pact.getMin().getUnit() != null) {
            return pact.getMax().getValue().add(pact.getMin().getValue()).divide(BigInteger.valueOf(2L)).doubleValue();
        }
        PartLog.getInstance().log(String.valueOf(pact.getName()) + " min/max values set", null);
        return 0.0;
    }

    public double getTimeUnit(Activation pact) {
        if (pact instanceof PeriodicActivation) {
            PeriodicActivation periodic = (PeriodicActivation)pact;
            double mean = this.getMeanActivation(periodic);
            if (periodic.getMax() != null && periodic.getMax().getUnit() != null) {
                switch (periodic.getMax().getUnit()) {
                    case MS: {
                        return mean * 0.001;
                    }
                    case US: {
                        return mean * 1.0E-6;
                    }
                    case NS: {
                        return mean * 1.0E-9;
                    }
                    case PS: {
                        return mean * 1.0E-12;
                    }
                    case S: {
                        return mean * 1.0;
                    }
                }
            } else {
                PartLog.getInstance().log(String.valueOf(periodic.getName()) + " requres a max value and a timeunit to be set", null);
            }
        }
        return 0.0;
    }

    public boolean AllRSCsHave2ValidEntries(EList<RunnableSequencingConstraint> rscl) {
        for (RunnableSequencingConstraint rsc : rscl) {
            if (rsc.getRunnableGroups().get(0) != null && rsc.getRunnableGroups().get(1) != null && 1 <= ((RunnableEntityGroup)rsc.getRunnableGroups().get(0)).getRunnables().size() && 1 <= ((RunnableEntityGroup)rsc.getRunnableGroups().get(1)).getRunnables().size()) continue;
            return false;
        }
        return true;
    }

    public boolean tRCsAreConsist(SWModel swm) {
        for (Runnable r : swm.getRunnables()) {
            if (r.getRunnableCalls().size() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean activationsAreHarmonic(EList<Activation> acts) {
        ArrayList<Double> pacts = new ArrayList<Double>();
        for (Activation act : acts) {
            if (act instanceof PeriodicActivation) {
                PeriodicActivation pa = (PeriodicActivation)act;
                pacts.add(this.getMeanActivation(pa));
                continue;
            }
            PartLog.getInstance().log(String.valueOf(act.getName()) + " is not a periodic activation and is ignored for harmonic activation analysis.");
        }
        Collections.sort(pacts, Collections.reverseOrder());
        if (pacts.size() > 1) {
            int i = 0;
            while (i < pacts.size()) {
                Double currentAct = (Double)pacts.get(i);
                int j = i;
                while (j < pacts.size()) {
                    if (currentAct % (Double)pacts.get(j) > 0.0) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean runnablesContainedinSamePP(EList<Runnable> runnables, EList<Runnable> runnables2) {
        for (Runnable r : runnables) {
            for (Runnable r2 : runnables2) {
                for (TaskRunnableCall rc : r.getTaskRunnableCalls()) {
                    for (TaskRunnableCall rc2 : r2.getTaskRunnableCalls()) {
                        if (!rc.eContainer().equals(rc2.eContainer())) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean runnablesContainedinSamePP(Runnable r1, Runnable r2) {
        for (TaskRunnableCall trc1 : r1.getTaskRunnableCalls()) {
            for (TaskRunnableCall trc2 : r2.getTaskRunnableCalls()) {
                if (!trc1.eContainer().equals(trc2.eContainer())) continue;
                return true;
            }
        }
        return false;
    }
}

