/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.multicore.partitioning.utils;

import org.apache.log4j.Logger;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class PartLog {
    protected Logger partlog;
    private boolean enableTargetConsoleLog;
    private boolean enableSourceConsoleLog;
    private MessageConsole console;
    private MessageConsoleStream outStream;

    public static PartLog getInstance() {
        return PartLogHandler.PL_INSTANCE;
    }

    public void setLogName(String name) {
        this.partlog = Logger.getLogger((String)name);
    }

    public void log(String message) {
        if (this.isEnableSourceConsoleLog()) {
            this.partlog.info((Object)message);
        }
        if (this.isEnableTargetConsoleLog()) {
            this.console = this.fetchConsole();
            if (this.console != null) {
                try {
                    this.outStream.println(message);
                }
                catch (Exception exception) {
                    this.outStream = this.console.newMessageStream();
                    this.outStream.println(message);
                }
            } else {
                System.out.println("NO CONSOLE");
            }
        }
    }

    private MessageConsole fetchConsole() {
        try {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] allConsoles = conMan.getConsoles();
            int i = 0;
            while (i < allConsoles.length) {
                if (allConsoles[i].getName().equals("Partitioning")) {
                    return (MessageConsole)allConsoles[i];
                }
                ++i;
            }
            MessageConsole newConsole = new MessageConsole("Partitioning", null);
            conMan.addConsoles(new IConsole[]{newConsole});
            return newConsole;
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("No Eclipse console available, using default output!");
            return null;
        }
    }

    public void logSimple(String message) {
        System.out.println(message);
        this.console = this.fetchConsole();
        if (this.console != null) {
            try {
                this.outStream.println(message);
            }
            catch (Exception exception) {
                this.outStream = this.console.newMessageStream();
                this.outStream.println(message);
            }
        }
    }

    public void log(String message, Exception e) {
        block9: {
            if (this.isEnableSourceConsoleLog()) {
                if (e != null) {
                    this.partlog.error((Object)(String.valueOf(message) + " " + e.getClass().getName()), e.getCause());
                } else {
                    this.partlog.error((Object)("Error: " + message));
                }
            }
            if (this.isEnableTargetConsoleLog()) {
                this.console = this.fetchConsole();
                if (this.console != null) {
                    try {
                        if (e != null) {
                            this.outStream.println(String.valueOf(message) + " " + e.getCause().toString());
                            break block9;
                        }
                        this.outStream.println("Error: " + message);
                    }
                    catch (Exception e1) {
                        this.outStream = this.console.newMessageStream();
                        this.outStream.println(String.valueOf(message) + " " + e1.toString());
                    }
                } else {
                    this.log("NO CONSOLE");
                }
            }
        }
    }

    public boolean isEnableTargetConsoleLog() {
        return this.enableTargetConsoleLog;
    }

    public void setEnableTargetConsoleLog(boolean enableTargetConsoleLog) {
        this.enableTargetConsoleLog = enableTargetConsoleLog;
    }

    public boolean isEnableSourceConsoleLog() {
        return this.enableSourceConsoleLog;
    }

    public void setEnableSourceConsoleLog(boolean enableSourceConsoleLog) {
        this.enableSourceConsoleLog = enableSourceConsoleLog;
    }

    private static class PartLogHandler {
        public static final PartLog PL_INSTANCE = new PartLog();

        private PartLogHandler() {
        }
    }
}

